package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.forum.vo.CommentVO;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.service.DynamicService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 *
 * @date 2023/5/15 10:29 概要：动态信息控制层
 */
@Api(tags = {"web-小程序-论坛社区-模块"})
@RestController
@RequestMapping("/dynamic")
public class DynamicController extends BaseController {

  @Resource private DynamicService dynamicService;

  @ApiOperation(value = "动态发布")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("/publish")
  public ResultBody publishDynamic(@RequestBody DynamicVO dynamicVO, HttpServletRequest request) {
    return dynamicService.insertDynamic(
        dynamicVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
  }

  @ApiOperation(value = "点赞或取消点赞")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @GetMapping("/likeOrCancel")
  public ResultBody likeOrCancel(
      HttpServletRequest request, @ApiParam(value = "动态id") @RequestParam Integer dynamicId) {
    return dynamicService.likeDynamic(
        this.getUserLoginInfoFromRedis(request).getUserAccountId(), dynamicId);
  }

  @ApiOperation(value = "评论动态或回复评论")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @PostMapping("/comment")
  public ResultBody commentDynamic(@RequestBody CommentVO commentVO, HttpServletRequest request) {
    return dynamicService.commentDynamic(
        commentVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
  }

  @ApiOperation(value = "删除评论")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
  @DeleteMapping("/removeComment")
  public ResultBody removeComment(@RequestParam Integer id) {
    return dynamicService.deleteComment(id);
  }

  @ApiOperation(value = "动态详情")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DynamicVO.class)})
  @GetMapping("/dynamicDetails")
  public ResultBody dynamicDetails(@RequestParam Integer dynamicId, HttpServletRequest request) {
    return dynamicService.dynamicDetails(
        dynamicId, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request);
  }
}
