package com.mmc.csf.release.entity.requirements;

import com.mmc.csf.infomation.dto.FlowDictionaryDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/8/22 13:22
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FlowDictionaryDO implements Serializable {

    private static final long serialVersionUID = -1811974173256250060L;

    private Integer id;

    @ApiModelProperty(value = "等待状态", example = "等待状态")
    private String waiting;

    @ApiModelProperty(value = "状态码", example = "状态码")
    private String orderStatus;

    @ApiModelProperty(value = "用户当前流程状态", example = "用户当前流程状态")
    private String userPort;

    @ApiModelProperty(value = "当前状态", example = "当前状态")
    private String doing;

    @ApiModelProperty(value = "飞手当前状态", example = "飞手当前状态")
    private String flyerPort;


    public FlowDictionaryDTO buildFlowDictionaryDTO() {
        return FlowDictionaryDTO.builder()
                .waiting(this.waiting)
                .orderStatus(this.orderStatus)
                .userPort(this.userPort)
                .doing(this.doing)
                .flyerPort(this.flyerPort)
                .build();
    }
}
