package com.mmc.csf.user.vo;

import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/10/17 17:24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ChangeUserPointVO implements Serializable {
    private static final long serialVersionUID = -1481188328848093579L;

    @ApiModelProperty(value = "用户id", example = "1")
    @NotNull(message = "用户id不能为空", groups = {Update.class})
    private Integer userAccountId;

    @ApiModelProperty(value = "变动类型", example = "1")
    private Integer changeType;

    @ApiModelProperty(value = "变动积分, 正加负减", example = "1")
    @NotNull(message = "变动积分不能为空", groups = {Update.class})
    private Integer changePoint;
}