package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/19 11:30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class IndustryCaseVO implements Serializable {
    private static final long serialVersionUID = 8278011392722950911L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "is不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "案例标题")
    @NotNull(message = "标题不能为空")
    private String caseTitle;
    @ApiModelProperty(value = "作者")
    private String caseAuthor;
    @ApiModelProperty(value = "发布者id")
    private Integer userAccountId;
    @ApiModelProperty(value = "来源")
    @NotNull(message = "来源不能为空")
    private String origin;
    @ApiModelProperty(value = "封面图")
    private String surfaceImg;
    @ApiModelProperty(value = "案例内容")
    private String caseContents;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "最新修改时间")
    private Date updateTime;
}
