package com.mmc.csf.infomation.qo;

import com.mmc.csf.release.model.group.Freeze;
import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/23 17:31
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MyPreemptQO {

    @ApiModelProperty(value = "需求id（不需要就不要传此字段）", required = true, example = "1")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    @ApiModelProperty(hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "描述",example = "1")
    private String requireDescription;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
