package com.mmc.csf.release.task.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/17 22:07
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class TaskServiceDetailVO implements Serializable {
    @ApiModelProperty(value = "服务id")
    private Integer id;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "服务图片")
    private String pictureUrl;

    @ApiModelProperty(value = "服务视频")
    private String videoUrl;

    @ApiModelProperty(value = "服务团队详情海报图")
    private String teamPoster;

    @ApiModelProperty(value = "服务亮点")
    private String lightSpot;

    @ApiModelProperty(value = "行业名称")
    private String industryName;

    @ApiModelProperty(value = "手射领取数")
    private Integer fakeNum;

    @ApiModelProperty(value = "内容")
    private String content;

    @ApiModelProperty(value = "评价信息")
    private List<EvaluateInfoVO> evaluateInfo;
    @ApiModelProperty(value = "评价总数量")
    private Integer item;

}
