package com.mmc.csf.release.commit;

import com.mmc.csf.release.controller.BaseController;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * @Author small
 * @Date 2023/8/18 11:05
 * @Version 1.0
 */
@Slf4j
@Component
@Aspect
public class NotRepeatSubmitConfig extends BaseController {
    @Autowired
    private RedissonClient redissonClient;


    @Pointcut("@within(notRepeatSubmit)||@annotation(notRepeatSubmit)")
    public void pointcut(NotRepeatSubmit notRepeatSubmit) {

    }

    @Around(value = "pointcut(notRepeatSubmit)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, NotRepeatSubmit notRepeatSubmit) throws Throwable {
        log.info("提交之前---");
        Object result = null;
        long leaseTime = notRepeatSubmit.value();
        log.info("leaseTime:" + leaseTime);

        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        String accountUriLockKey = userAccountId + "-" + request.getServletPath();
        // 设置锁定资源名称，accountUriLock改为userid+uri作为标识，作为测试写死
        //   String accountUriLockKey = "accountUriLock";

        RLock accountUriLock = redissonClient.getLock(accountUriLockKey);
        boolean tryLock;

        //尝试获取分布式锁
        //-1为永久  leaseTime 最多等待几秒   上锁以后leaseTime秒自动解锁
        tryLock = accountUriLock.tryLock(-1, leaseTime, TimeUnit.MILLISECONDS);
        log.info("tryLock:" + tryLock);
        if (tryLock) {
            try {

                // 查询订单库存判断是否大于0
                //                大于0表示还有库存可以更新订单库存将库存数字减一更新到数据库中
                //        不大于0表示没有库存了本次请求就终止
                log.info("正常提交：");
                result = proceedingJoinPoint.proceed();
            } catch (Exception e) {
                log.info("主程序异常：" + e);
                throw new Exception(e);
            }
        } else {
            log.info("重复提交：" + accountUriLockKey);
        }
        log.info("提交之后---");
        return result;

    }


}
