package com.mmc.csf.infomation.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/22 10:43
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class RequirementsAmountVO {

    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id", hidden = true)
    private Integer id;

    @ApiModelProperty(value = "修改任务佣金", example = "900")
    private BigDecimal updateOrderAmount;

    @ApiModelProperty(value = "需求id", example = "1")
    @NotNull(message = "需求id不能为空")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "用户id", example = "用户id", hidden = true)
    private Integer userAccountId;
    @ApiModelProperty(value = "原因", example = "原因")
    private String reason;
    @ApiModelProperty(value = "图片地址", example = "http://")
    private String url;
    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3", required = true)
    private String paymentType;

    @ApiModelProperty(value = "修改后微信支付订单编号")
    private String wechatPayOrderNumber;


}
