package com.mmc.csf.release.service.gambit.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.DynamicDao;
import com.mmc.csf.release.dao.gambit.GambitDao;
import com.mmc.csf.release.entity.forum.*;
import com.mmc.csf.release.entity.gambit.ForumAttentionDO;
import com.mmc.csf.release.entity.gambit.ForumGambitDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.forum.vo.ForumReviewVO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import com.mmc.csf.release.gambit.dto.ForumDynamicGambitDTO;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.qo.*;
import com.mmc.csf.release.gambit.vo.ForumGambitVO;
import com.mmc.csf.release.service.gambit.GambitService;
import com.mmc.csf.user.vo.UserAccountVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/9/13 15:30
 * @Version 1.0
 */
@Service
public class GambitServiceImpl implements GambitService {

    @Autowired
    private GambitDao gambitDao;


    @Autowired
    private DynamicDao dynamicDao;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Autowired
    private UserAppApi userAppApi;

    /**
     * 添加话题
     * @param forumGambitVO
     * @return
     */
    @Override
    public ResultBody insertGambit(ForumGambitVO forumGambitVO) {
        ForumGambitDO forumGambitDO = new ForumGambitDO(forumGambitVO);
        List<ForumGambitDO> forumGambitDOS = gambitDao.recommendCount(forumGambitDO);
        if ("3".equals(forumGambitDO.getGambitProperty().toString())){
            int size = forumGambitDOS.size();
            if (size>=3){
                return ResultBody.error("推荐最多只能三个");
            }
        }
        if ("2".equals(forumGambitDO.getGambitProperty().toString())){
            int size = forumGambitDOS.size();
            if (size>=3){
                return ResultBody.error("热门最多只能三个");
            }
        }
        int i = gambitDao.selectGambit(forumGambitDO.getGambitName());
        if (i!=0){
         return    ResultBody.error("话题名称已存在");
        }
        gambitDao.insertGambit(forumGambitDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateGambit(ForumGambitVO forumGambitVO) {
        ForumGambitDO forumGambitDO = new ForumGambitDO(forumGambitVO);
        List<ForumGambitDO> forumGambitDOS = gambitDao.recommendCountNO(forumGambitDO);
        if ("3".equals(forumGambitDO.getGambitProperty().toString())){
            int size = forumGambitDOS.size();
            if (size>=3){
                return ResultBody.error("推荐最多只能三个");
            }
        }
        if ("2".equals(forumGambitDO.getGambitProperty().toString())){
            int size = forumGambitDOS.size();
            if (size>=3){
                return ResultBody.error("热门最多只能三个");
            }
        }
        int i = gambitDao.selectUpdate(forumGambitDO);
        if (i!=0){
            return ResultBody.error("话题名称不能重复");
        }
        gambitDao.updateGambit(forumGambitDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteGambit(Integer id) {

     int count=  gambitDao.selectGambitAndDynamic(id);
     if (count==0){
         return ResultBody.error("话题关联了动态无法删除");
     }
        gambitDao.deleteGambit(id);
        gambitDao.forumDynamicGambit(id);
        return ResultBody.success();
    }

    @Override
    public PageResult listGambit(ForumGambitQO forumGambitQO) {
        Integer pageNo = forumGambitQO.getPageNo();
        forumGambitQO.buildCurrentPage();
        int count = gambitDao.listGambitCount(forumGambitQO);
        List<ForumGambitDO> forumGambitDO = gambitDao.listGambit(forumGambitQO);
        List<ForumGambitDTO> collect = forumGambitDO.stream().map(ForumGambitDO::buildForumGambitDTO).collect(Collectors.toList());
       return PageResult.buildPage(pageNo, forumGambitQO.getPageSize(),count,collect);
    }

    @Override
    public ResultBody attention( Boolean status, Integer userAccountId,Integer attentionUserAccountId) {
        if (status.equals(true)){
            //插入用户
            int count = dynamicDao.selectForumCount(userAccountId);
            if (count==0){
                dynamicDao.insertForumCount(userAccountId);
            }
            int count1 = dynamicDao.selectForumCount(attentionUserAccountId);
            if (count1==0){
                dynamicDao.insertForumCount(attentionUserAccountId);
            }
            ForumAttentionDO forumAttentionDO = gambitDao.selectAttentionMessage(userAccountId, attentionUserAccountId);
            ForumAttentionDO forumAttentionDOs =  gambitDao.selectAttentionM(userAccountId,attentionUserAccountId);
            if (forumAttentionDO!=null ||forumAttentionDOs!=null){
                gambitDao.updateAttention(userAccountId,attentionUserAccountId,true);
                gambitDao.forumCountFansYes(userAccountId);
                gambitDao.forumCountAttentionYes(attentionUserAccountId);
            }else{
                gambitDao.insertAttention(userAccountId,attentionUserAccountId,status);
                gambitDao.forumCountFansYes(userAccountId);
                gambitDao.forumCountAttentionYes(attentionUserAccountId);
            }
        }else{
            ForumAttentionDO forumAttentionDO = gambitDao.selectAttentionMessage(userAccountId, attentionUserAccountId);
            if (forumAttentionDO.getMutualAttention().equals(false)){
                gambitDao.removeAttention(userAccountId,attentionUserAccountId);
                gambitDao.forumCountFansNO(userAccountId);
                gambitDao.forumCountAttentionNO(attentionUserAccountId);
            }else{
             gambitDao.updateAttentionExchange(userAccountId,attentionUserAccountId);
             gambitDao.forumCountFansNO(userAccountId);
             gambitDao.forumCountAttentionNO(attentionUserAccountId);
            }
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody transPond(Integer dynamicId, Integer userAccountId) {
        gambitDao.insertTransPond(dynamicId,userAccountId);
        gambitDao.transPondCount(dynamicId);
        return ResultBody.success();
    }

    @Override
    public ResultBody commentLikes(Integer userAccountId, Integer dynamicId) {
        gambitDao.commentLikes(dynamicId,userAccountId);
        return ResultBody.success();
    }


    @Override
    public ResultBody appRemove(Integer userAccountId, Integer dynamicId) {
        int i = gambitDao.selectGambitM(dynamicId, userAccountId);
        if (i!=0){
            return ResultBody.error("只能删除自己的贴子");
        }
        gambitDao.appRemove(dynamicId);
        gambitDao.RemoveDynamicGambit(dynamicId);

        return ResultBody.success();
    }


    @Override
    public PageResult appGambitList(TopicDynamicsQO topicDynamicsQO) {
        Integer pageNo = topicDynamicsQO.getPageNo();
        topicDynamicsQO.buildCurrentPage();
        int count = gambitDao.appGambitListCount(topicDynamicsQO);
        List<ForumDynamicGambitDO> forumDynamicGambitDOS = gambitDao.appGambitList(topicDynamicsQO);
       return PageResult.buildPage(pageNo, topicDynamicsQO.getPageSize(),count,forumDynamicGambitDOS);
    }

    @Override
    public PageResult userDynamicList(UserTopicDynamicsQO userTopicDynamicsQO){
        Integer pageNo = userTopicDynamicsQO.getPageNo();
        userTopicDynamicsQO.buildCurrentPage();
        int count = gambitDao.userDynamicListCount(userTopicDynamicsQO);
        List<ForumDynamicGambitDO> forumDynamicGambitDOS = gambitDao.userDynamicList(userTopicDynamicsQO);
        return PageResult.buildPage(pageNo, userTopicDynamicsQO.getPageSize(),count,forumDynamicGambitDOS);
    }

    @Override
    public PageResult liked(UserTopicDynamicsQO userTopicDynamicsQO, HttpServletRequest request) {
        Integer pageNo = userTopicDynamicsQO.getPageNo();
        userTopicDynamicsQO.buildCurrentPage();
        int count = gambitDao.likedCount(userTopicDynamicsQO);
        List<ForumDynamicGambitDO> forumDynamicGambitDOS = gambitDao.likedList(userTopicDynamicsQO);
        List<DynamicVO> collect = forumDynamicGambitDOS.stream().map(ForumDynamicGambitDO::buildForumDynamicGambitDTO).collect(Collectors.toList());


        List<Integer> userAccountIds =
                collect.stream().map(DynamicVO::getUserAccountId).collect(Collectors.toList());
        UserAccountQO bUserAccountQO = new UserAccountQO();
        bUserAccountQO.setUserIds(userAccountIds);
        bUserAccountQO.setPageNo(1);
        bUserAccountQO.setPageSize(999);
        // 获取用户的信息
        List<UserAccountSimpleDTO> userAccountSimpleDTOS =
                userAppApi.feignListAppUserAccount(bUserAccountQO, request.getHeader(TokenConstant.TOKEN));

        for (DynamicVO dynamicVO : collect) {
            for (UserAccountSimpleDTO userAccountSimpleDTO : userAccountSimpleDTOS) {
                if (dynamicVO.getUserAccountId().equals(userAccountSimpleDTO.getId())) {
                    UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                    userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                    userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                    userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                    userBaseInfoVO.setPhone(userAccountSimpleDTO.getPhoneNum());
                    userBaseInfoVO.setUid(userAccountSimpleDTO.getUid());
                    dynamicVO.setUserBaseInfo(userBaseInfoVO);
                    break;
                }
            }
        }

        for (DynamicVO dynamicVO : collect) {
            ForumReviewVO forumReviewVO = dynamicVO.getForumReviewVO();
            Integer userAccountId = forumReviewVO.getUserAccountId();
            UserAccountVO info = info(userAccountId);
            forumReviewVO.setUserAccountVO(info);
        }

        return PageResult.buildPage(pageNo, userTopicDynamicsQO.getPageSize(),count,collect);
    }
    @Override
    public PageResult myInterestList(UserTopicDynamicsQO userTopicDynamicsQO) {

        Integer pageNo = userTopicDynamicsQO.getPageNo();
        userTopicDynamicsQO.buildCurrentPage();
       int count = gambitDao.myInterestListCount(userTopicDynamicsQO);
       List<MyAttentionDO> myAttentionDOS = gambitDao.myInterestList(userTopicDynamicsQO);
        return  PageResult.buildPage(pageNo, userTopicDynamicsQO.getPageSize(),count,myAttentionDOS);
    }

    @Override
    public PageResult myFansList(UserTopicDynamicsQO userTopicDynamicsQO) {
        Integer pageNo = userTopicDynamicsQO.getPageNo();
        userTopicDynamicsQO.buildCurrentPage();
        int count = gambitDao.myFansListCount(userTopicDynamicsQO);
        List<MyFansDO> myAttentionDOS = gambitDao.myFansList(userTopicDynamicsQO);
        return  PageResult.buildPage(pageNo, userTopicDynamicsQO.getPageSize(),count,myAttentionDOS);

    }

    @Override
    public ResultBody userMessage(Integer userAccountId,Integer userId) {
      ForumCountDO forumCountDO= gambitDao.userMessage(userAccountId);
        int i= gambitDao.selectCountAttentions(userAccountId,userId);
      //  int i = gambitDao.selectCountAttention(userId);
        if (i!=0){
            forumCountDO.setStatus(true);
        }
        return ResultBody.success(forumCountDO);
    }

    @Override
    public PageResult allCommentList(AllReviewQO allReviewQO) {
        Integer pageNo = allReviewQO.getPageNo();
        allReviewQO.buildCurrentPage();
       int count = gambitDao.allCommentListCount(allReviewQO);
        List<ForumReviewDO> forumReviewDOS = gambitDao.allCommentList(allReviewQO);
        for (ForumReviewDO forumReviewDO : forumReviewDOS) {
            UserAccountVO info = info(forumReviewDO.getUserAccountId());
            forumReviewDO.setUserAccountVO(info);
        }
        for (ForumReviewDO forumReviewDO : forumReviewDOS) {
          int counts =  gambitDao.replyCount(forumReviewDO);
          forumReviewDO.setReplyCount(counts);
        }
        return PageResult.buildPage(pageNo,allReviewQO.getPageSize(),count,forumReviewDOS);
    }

    @Override
    public PageResult replyList(AppReplyQO allReviewQO) {
        Integer pageNo = allReviewQO.getPageNo();
        allReviewQO.buildCurrentPage();
       int count = gambitDao.replyListCount(allReviewQO);
        List<ForumReviewDO> forumReviewDOS = gambitDao.replyList(allReviewQO);
        for (ForumReviewDO forumReviewDO : forumReviewDOS) {
            UserAccountVO info = info(forumReviewDO.getUserAccountId());
            forumReviewDO.setUserAccountVO(info);
        }

        return PageResult.buildPage(pageNo,allReviewQO.getPageSize(),count,forumReviewDOS);
    }


    public UserAccountVO info(Integer userAccountId) {
        String token = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(userAccountId.toString(), headers);
        ResponseEntity<String> exchange = restTemplate.exchange(userApp + "/userapp/user-account/interiorInfo?userAccountId=" + userAccountId , HttpMethod.GET, entity, String.class);
        Object body = exchange.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String) body);
        JSONObject result1 = (JSONObject) jsonObject.get("result");
        UserAccountVO userAccountVO = JSON.parseObject(result1.toJSONString(), UserAccountVO.class);
        return userAccountVO;
    }


}
