package com.mmc.csf.release.dao;

import com.mmc.csf.release.entity.FlightSkillsDO;
import com.mmc.csf.release.entity.PilotRegistrationDO;
import com.mmc.csf.release.vo.DronePilotLicenseVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 11:34
 * 概要：
 */
@Mapper
public interface FlyerTrainingDao {

    /**
     * 插入飞手报名登记信息
     *
     * @param pilotRegistrationDO 飞行员信息登记
     */
    void insertPilotRegistrationInfo(PilotRegistrationDO pilotRegistrationDO);

    List<DronePilotLicenseVO> selectAllLicenses();

    /**
     * 行业飞行技能列表
     *
     * @return {@link List}<{@link FlightSkillsDO}>
     */
    List<FlightSkillsDO> listIndustryFlightSkills();
}
