package com.mmc.csf.web.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/4/22 10:12
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WebsiteVO implements Serializable {
    @ApiModelProperty(value = "省份编码")
    @NotNull(message = "省份编码不能为空")
    private String adCode;
    @ApiModelProperty(value = "经度")
    @NotNull(message = "经度不能为空")
    private Double lon;
    @ApiModelProperty(value = "纬度")
    @NotNull(message = "纬度不能为空")
    private Double lat;
}
