package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.*;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.commit.NotRepeatSubmit;
import com.mmc.csf.release.entity.requirements.ServiceRequirementsDO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.RequirementsService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/18 14:26
 */
@Api(tags = {"需求相关"})
@RestController
@RequestMapping("/requirements/")
public class RequirementsController extends BaseController {

    @Autowired
    private RequirementsService requirementsService;

    @ApiOperation(value = "需求类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsTypeVO.class)})
    @GetMapping("listType")
    public ResultBody listType(@RequestParam(value = "1", required = false) Integer id) {
        return requirementsService.listType(id);
    }

    @ApiOperation(value = "流程字典")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsTypeVO.class)})
    @GetMapping("flowDictionary")
    public ResultBody<FlowDictionaryDTO> flowDictionary() {

        return requirementsService.flowDictionary();
    }


    @ApiOperation(value = "流程字典(包含流程时间)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsTypeVO.class)})
    @GetMapping("flowDictionaryAndTime")
    public ResultBody<FlowDictionaryAndTimeDTO> flowDictionaryAndTime(HttpServletRequest request,
                                                                      @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        return requirementsService.flowDictionaryAndTime(requirementsInfoId);
    }


    @ApiOperation(value = "小程序——发布需求信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publish")
    public ResultBody publish(@RequestBody @Validated(value = {Insert.class}) RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        requirementsInfoVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.publish(requirementsInfoVO, request);
    }

    @ApiOperation(value = "小程序——发布服务需求")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publishService")
    public ResultBody publishService(@RequestBody @Validated(value = {Insert.class}) ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request) {
        serviceRequirementsVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.publishService(serviceRequirementsVO, request);
    }


    @ApiOperation(value = "new——小程序发布服务-——抢单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @NotRepeatSubmit(value = 3000L)
    @PostMapping("grabTheOrder")
    public ResultBody grabTheOrder(@RequestBody GrabTheOrderVO grabTheOrderVO, HttpServletRequest request) {

        String phoneNum = this.getUserLoginInfoFromRedis(request).getPhoneNum();

        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        grabTheOrderVO.setUserAccountId(userAccountId);
        grabTheOrderVO.setPhoneNum(phoneNum);
        return requirementsService.grabTheOrder(grabTheOrderVO, request);
    }


    @ApiOperation(value = "内部调用")
    @GetMapping("/repertory")
    public ServiceRequirementsDO repertory(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        GrabTheOrderVO grabTheOrderVO = new GrabTheOrderVO();
        grabTheOrderVO.setRequirementsInfoId(requirementsInfoId);
        return requirementsService.getRepertory(grabTheOrderVO, request);
    }


    @ApiOperation(value = "小程序——发布服务需求订单编号单独接口")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publisherNumber")
    public ResultBody<GetOrderNumberDTO> publisherNumber(@RequestBody GetOrderNumberVO getOrderNumberVO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        getOrderNumberVO.setUserAccountId(userAccountId);
        return requirementsService.publisherNumber(getOrderNumberVO, request);
    }


    @ApiOperation(value = "小程序-编辑——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePublish")
    public ResultBody updatePublish(@RequestBody @Validated(value = {Update.class}) RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        requirementsInfoVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.updatePublish(requirementsInfoVO, request);
    }


    @ApiOperation(value = "小程序——修改发布服务需求订单编号单独接口")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePublisherNumber")
    public ResultBody<GetOrderNumberDTO> updatePublisherNumber(@RequestBody GetOrderNumberUpdateVO getOrderNumberUpdateVO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        getOrderNumberUpdateVO.setUserAccountId(userAccountId);
        return requirementsService.updatePublisherNumber(getOrderNumberUpdateVO, request);
    }


    @ApiOperation(value = "小程序-编辑——服务需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateServicePublish")
    public ResultBody updateServicePublish(@RequestBody @Validated(value = {Update.class}) ServiceRequirementsEditVO requirementsInfoVO, HttpServletRequest request) {
        requirementsInfoVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.updateServicePublish(requirementsInfoVO, request);
    }


    @ApiOperation(value = "小程序-删除——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deletePublish")
    public ResultBody deletePublish(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer id, HttpServletRequest request) {
        return requirementsService.deletePublish(id, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "new——发布者删除服务需求")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deletePublishService")
    public ResultBody deletePublishService(@RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        return requirementsService.deletePublishService(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "new——抢单者删除服务需求")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deletePreempt")
    public ResultBody deletePreempt(@RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        return requirementsService.deletePreempt(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "小程序-列表——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("appPublishList")
    public ResultBody<RequirementsInfoVO> appPublishList(@RequestBody RequirementsInfoQO requirementsInfoQO) {
        return requirementsService.appPublishList(requirementsInfoQO);
    }


    @ApiOperation(value = "小程序-详情——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("detailPublish")
    public ResultBody<RequirementsInfoVO> detailPublish(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer id, HttpServletRequest request) {
        return requirementsService.detailPublish(id, request, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "new——小程序-—服务订单--我的发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("myPublish")
    public ResultBody<RequirementsInfoVO> myPublish(HttpServletRequest request, @Validated(value = {Page.class}) @ApiParam(value = "我的发单", required = true) @RequestBody MyPublishQO param) {
        return ResultBody.success(requirementsService.myPublish(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
    }

    @ApiOperation(value = "小程序——我的发布(需要派单列表)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("mySendPublish")
    public ResultBody<RequirementsInfoVO> mySendPublish(HttpServletRequest request, @Validated(value = {Page.class}) @ApiParam(value = "我的发单", required = true) @RequestBody MyPublishQO param) {
        return ResultBody.success(requirementsService.mySendPublish(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
    }


    @ApiOperation(value = "new——小程序-—服务订单--我的抢单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("myPreempt")
    public ResultBody<RequirementsInfoVO> myPreempt(HttpServletRequest request,
                                                    @Validated(value = {Page.class}) @ApiParam(value = "我的抢单", required = true) @RequestBody MyPreemptQO param) {
        return ResultBody.success(requirementsService.myPreempt(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
    }

    @ApiOperation(value = "new——小程序-—飞手端--抵达现场")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("arriveAtTheScene")
    public ResultBody arriveAtTheScene(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceArriveSceneVO serviceArriveSceneVO) {
        serviceArriveSceneVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.arriveAtTheScene(serviceArriveSceneVO);
    }


    @ApiOperation(value = "new——小程序-—飞手端--抵达现场详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("arriveAtTheSceneDetails")
    public ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.arriveAtTheSceneDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—飞手端--完成任务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("fulfilATask")
    public ResultBody fulfilATask(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceFulfilATaskVO fulfilATaskVO) {
        fulfilATaskVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.fulfilATask(fulfilATaskVO);
    }


    @ApiOperation(value = "new——小程序-—飞手端--完成任务详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("fulfilATaskDetails")
    public ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.fulfilATaskDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—发布者--订单结算")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("settleAccounts")
    public ResultBody settleAccounts(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceSettleAccountsVO settleAccountsVO) {
        settleAccountsVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.settleAccounts(settleAccountsVO, request);
    }


    @ApiOperation(value = "new--小程序————飞手端最终确认结算")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("confirmSettlement")
    public ResultBody confirmSettlement(HttpServletRequest request, @RequestParam(value = "需求id") Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.confirmSettlement(userAccountId, requirementsInfoId, request);
    }

    @ApiOperation(value = "new——小程序-—发布者--订单结算详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("settleAccountsDetails")
    public ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.settleAccountsDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—发布者对飞手--评价")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("evaluate")
    public ResultBody evaluate(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceEvaluateVO evaluateVO) {
        evaluateVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.evaluate(evaluateVO);
    }


    @ApiOperation(value = "new——小程序-—发布者对飞手--评价详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("evaluateDetails")
    public ResultBody<ServiceEvaluateDTO> evaluateDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.evaluateDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—飞手单方便取消订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("droneFlyerCancel")
    public ResultBody droneFlyerCancel(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.droneFlyerCancel(requirementsInfoId, userAccountId, request);
    }

    @ApiOperation(value = "new——小程序-—发布者单方便取消订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("publisherCancel")
    public ResultBody publisherCancel(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.publisherCancel(requirementsInfoId, userAccountId, request);
    }

    @ApiOperation(value = "new——小程序-—结算:发布者修改任务佣金")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePublisherCancel")
    public ResultBody updatePublisherCancel(HttpServletRequest request, @RequestBody RequirementsAmountVO amountVO) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        amountVO.setUserAccountId(userAccountId);
        return requirementsService.updatePublisherCancel(amountVO, request);
    }

    @ApiOperation(value = "new——小程序-—修改佣金后飞手确认结算")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("flyHandAgree")
    public ResultBody flyHandAgree(HttpServletRequest request, @RequestBody FlyHandAgreeVO agreeVO) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        agreeVO.setUserAccountId(userAccountId);
        return requirementsService.flyHandAgree(agreeVO, request);
    }


    @ApiOperation(value = "new--小程序——结算时修改任务佣金获取订单编号")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateAmountGetNumber")
    public ResultBody<GetOrderNumberDTO> updateAmountGetNumber(@RequestBody UpdateAmountGetNumberVO getNumberVO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        getNumberVO.setUserAccountId(userAccountId);
        return requirementsService.updateAmountGetNumber(getNumberVO, request);
    }

    /**
     * 客服介入
     *
     * @param request
     * @param liabilityProblemVO
     * @return
     */
    @ApiOperation(value = "new2——后台管理取消订单(取消发布者与飞手共同建立的订单)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("cancelAll")
    public ResultBody cancelAll(HttpServletRequest request, @RequestBody LiabilityProblemVO liabilityProblemVO) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.cancelAll(liabilityProblemVO, userAccountId, request);
    }


    @ApiOperation(value = "后台管理-详情——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("backDetailPublish")
    public ResultBody<RequirementsInfoVO> backDetailPublish(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer id, HttpServletRequest request) {
        return requirementsService.backDetailPublish(id, request, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "需求发布列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsInfoVO.class)})
    @PostMapping("listPublishPage")
    public ResultBody listPublishPage(@Validated(value = {Page.class}) @RequestBody IndustryCaseQO
                                              industryCaseQO, HttpServletRequest request) {
        return requirementsService.listPublishPage(industryCaseQO, request);
    }

    @ApiOperation(value = "需求已解决")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("solveRequire")
    public ResultBody solveRequire(@RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        return requirementsService.solveRequire(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "删除需求")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteRequire")
    public ResultBody deleteRequire(@RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        return requirementsService.deleteRequire(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "小程序—抢单——获取子订单详细信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("selectRequireSonInfo")
    public ResultBody<RequirementsInfoVO> selectRequireSonInfo(HttpServletRequest request, @Validated(value = {Page.class}) @ApiParam(value = "查询所有子订单信息", required = true) @RequestBody MyPublishQO param) {
        param.setType(0);
        return ResultBody.success(requirementsService.selectRequireSonInfo(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
    }

    @ApiOperation(value = "小程序——派单——获取子订单信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("selectRequireInfo")
    public ResultBody<RequirementsInfoVO> selectRequireInfo(HttpServletRequest request, @Validated(value = {Page.class}) @ApiParam(value = "查询所有子订单信息", required = true) @RequestBody MyPublishQO param) {
        param.setType(1);
        return ResultBody.success(requirementsService.selectRequireSonInfo(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
    }
    @ApiOperation(value = "小程序—发单方(同意/拒绝)该飞手")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("agreeOrRefusePilot")
    public ResultBody agreeOrRefusePilot(@Validated @RequestBody AgreeOrRefusePilotQO param) {
        return requirementsService.agreeOrRefusePilot(param);
    }

    @ApiOperation(value = "飞手派单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/personSendOrder")
    public ResultBody personSendOrder(HttpServletRequest request,@RequestBody PersonSendOrderVO personSendOrderVO) {
        return requirementsService.personSendOrder(personSendOrderVO,this.getUserLoginInfoFromRedis(request).getToken());
    }
    @ApiOperation(value = "团队派单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/teamSendOrder")
    public ResultBody teamSendOrder(HttpServletRequest request,
            @ApiParam(value = "父订单id")@RequestParam Integer fatherRequireId,
                                    @ApiParam(value = "团队管理员的id")@RequestParam Integer messageId) {
        return requirementsService.teamSendOrder(fatherRequireId,messageId,this.getUserLoginInfoFromRedis(request).getToken());
    }

    @ApiOperation(value = "我的派单列表——待确认")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("mySendOderList")
    public ResultBody<RequirementsInfoVO> mySendOderList(HttpServletRequest request,
                                                    @Validated(value = {Page.class}) @ApiParam(value = "我的抢单", required = true) @RequestBody MyPreemptQO param) {
        return ResultBody.success(requirementsService.mySendOderList(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
//        return ResultBody.success(requirementsService.mySendOderList(337, param));
    }
    @ApiOperation(value = "我的派单——去确认")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("orderConfirmationByPilot")
    public ResultBody orderConfirmationByPilot(HttpServletRequest request,
            @ApiParam(value = "派单id") @RequestParam Integer tempId,
            @ApiParam(value = "确认状态：1同意，2不同意") @RequestParam Integer status) {
        return requirementsService.orderConfirmationByPilot(tempId,status,this.getUserLoginInfoFromRedis(request).getToken());
    }

    @ApiOperation(value = "管理员确认（拒绝）派单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("adminAgreeOrder")
    public ResultBody adminAgreeOrder(HttpServletRequest request,
            @ApiParam(value = "派单id") @RequestParam Integer requireId,
            @ApiParam(value = "确认状态：1同意，2不同意") @RequestParam Integer status) {
        return requirementsService.orderConfirmationByTeam(requireId,status,this.getUserLoginInfoFromRedis(request).getToken());
    }
}