package com.mmc.csf.release.task.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.release.model.group.Create;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author Lw
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.model.vo.OrderTaskVO", description = "订单增改VO")
public class OrderTaskVO implements Serializable {
	private static final long serialVersionUID = -2965614984473801301L;
	@ApiModelProperty(value = "服务id")
	@NotNull(message = "服务id不能为空", groups = { Create.class})
	private Integer inspectionId;
	@ApiModelProperty(value = "industryId")
	@NotNull(message = "industryId不能为空", groups = { Create.class })
	private Integer industryId;
	@ApiModelProperty(value = "服务开始时间", example = "2021-04-09 12:12:12")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date startTime;
	@ApiModelProperty(value = "服务结束时间", example = "2021-04-09 12:12:12")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date endTime;
	@ApiModelProperty(value = "任务描述", example = "0")
	@Size(max = 400, message = "备注内容不能超过400个字符", groups = { Create.class})
	private String taskDesc;
	@ApiModelProperty(value = "图片地址", example = "0")
	private List<String> filePath;
	@ApiModelProperty(value = "详细地址")
	private String taskAddress;
	@ApiModelProperty(value = "经度")
	private BigDecimal lon;
	@ApiModelProperty(value = "纬度")
	private BigDecimal lat;
}
