package com.mmc.csf.release.entity.licence;

import com.mmc.csf.licence.dto.LicenseOrganizationsDTO;
import com.mmc.csf.licence.dto.LicenseTrainingProgramsDTO;
import com.mmc.csf.licence.vo.LicenseOrganizationsVO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/13 16:42
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LicenseOrganizationsDO {

    @ApiModelProperty(value = "机构id", example = "1")
    @NotNull(message = "机构id", groups = Update.class)
    private Integer id;
    @ApiModelProperty(value = "机构主图不能为空", example = "http://", required = true)
    //@Size(max = 10, message = "机构主图")
    @NotBlank(message = "机构主图不能为空", groups = {Create.class, Update.class})
    private String mainImage;
    @ApiModelProperty(value = "机构副图不能为空", example = "http://", required = true)
    @NotBlank(message = "机构副图不能为空", groups = {Create.class, Update.class})
    private String auxiliaryPicture;

    @ApiModelProperty(value = "机构视频", example = "http://")
    private String video;

    @ApiModelProperty(value = "机构名称不能为空", example = "科比特智能教育", required = true)
    @NotBlank(message = "机构名称不能为空", groups = {Create.class, Update.class})
    private String name;

    @ApiModelProperty(name = "机构地区", example = "110000,110100")
    @NotBlank(message = "机构地区不能为空", groups = {Create.class, Update.class})
    private String region;

    @ApiModelProperty(name = "机构地区名称", example = "河北省,石家庄市", required = true)
    @NotBlank(message = "机构地区名称", groups = {Create.class, Update.class})
    private String regionName;

    @ApiModelProperty(name = "机构详细地址", example = "南山区")
    @NotBlank(message = "机构详细地址不能为空", groups = {Create.class, Update.class})
    private String detailedAddress;

    @ApiModelProperty(name = "是否是考点机构", example = "0", required = true)
    @NotNull(message = "考点机构不能为空", groups = {Create.class, Update.class})
    private Integer testCenter;

    @ApiModelProperty(name = "机构规模id不能为空", example = "1")
    private Integer scaleId;

    @ApiModelProperty(name = "机构规模名称", example = "1")
    private String scaleName;

    @ApiModelProperty(name = "机构描述", example = "机构描述0001")
    private String description;

    @ApiModelProperty(name = "机构详情", example = "机构详情0001")
    private String detail;

    @ApiModelProperty(name = "机构培训项目id", example = "1,2")
    private List<Integer> orgTrainingIds;

    @ApiModelProperty(name = "培训项目", required = false)
    private List<LicenseTrainingProgramsDTO> programsDOList;


    @ApiModelProperty(value = "经度", example = "40.892313123", required = true)
    private Double longitude;

    @ApiModelProperty(value = "纬度", example = "50.892313123", required = true)
    private Double latitude;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间", example = "2023-07-14", required = true)
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间", example = "2023-07-14", required = true)
    private Date updateTime;

    /**
     * VO类转换
     */
    public LicenseOrganizationsDO(LicenseOrganizationsVO organizationsVO) {
        this.id = organizationsVO.getId();
        this.mainImage = organizationsVO.getMainImage();
        this.auxiliaryPicture = organizationsVO.getAuxiliaryPicture();
        this.video = organizationsVO.getVideo();
        this.name = organizationsVO.getName();
        this.region = organizationsVO.getRegion();
        this.testCenter = organizationsVO.getTestCenter();
        this.scaleId = organizationsVO.getScaleId();
        this.description = organizationsVO.getDescription();
        this.detail = organizationsVO.getDetail();
        this.detailedAddress = organizationsVO.getDetailedAddress();
        this.regionName = organizationsVO.getRegionName();
        this.longitude = organizationsVO.getLongitude();
        this.latitude = organizationsVO.getLatitude();
    }


    /**
     * DTO转换
     *
     * @return
     */
    public LicenseOrganizationsDTO organizationsDTO() {
        return LicenseOrganizationsDTO.builder()
                .id(this.id)
                .mainImage(this.mainImage)
                .auxiliaryPicture(this.auxiliaryPicture)
                .video(this.video)
                .name(this.name)
                .region(this.region)
                .detailedAddress(this.detailedAddress)
                .scaleId(this.scaleId)
                .testCenter(this.testCenter)
                .scaleName(this.scaleName)
                .description(this.description)
                .detail(this.detail)
                .programsDOList(this.programsDOList)
                .regionName(this.regionName)
                .longitude(this.longitude)
                .latitude(this.latitude)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .build();
    }
}
