package com.mmc.csf.infomation.qo;

import com.mmc.csf.release.model.group.Freeze;
import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/29 10:25
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceOrderQO {


    @ApiModelProperty(value = "发单手机号", required = false, example = "189213123213")
    private String publishPhone;

    @ApiModelProperty(value = "抢单手机号", required = false, example = "18923131321")
    private String preemptPhone;

    @ApiModelProperty(value = "1:正常 2:争议订单", required = false, example = "1")
    private Integer orderAttribute;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
