package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.other.LocationUtils;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.dao.WebsiteDao;
import com.mmc.csf.release.entity.WebsiteInfoDO;
import com.mmc.csf.release.service.WebsiteService;
import com.mmc.csf.web.dto.WebsiteRangeDTO;
import com.mmc.csf.web.vo.LocationVO;
import com.mmc.csf.web.vo.WebsiteVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2022/4/21 19:19
 * 概要：
 */
@Service
public class WebsiteServiceImpl implements WebsiteService {
    @Autowired
    private WebsiteDao websiteDao;

    @Override
    public ResultBody getWebsiteByAdCode(String adCode) {
        WebsiteInfoDO websiteInfoDO = websiteDao.getWebsiteByAdCode(adCode);
        return ResultBody.success(websiteInfoDO.buildWebsiteDTO());
    }

    @Override
    public ResultBody getWebsiteList(Double lon, Double lat) {
        List<WebsiteInfoDO> list = websiteDao.getWebsiteList();
        List<WebsiteRangeDTO> rangeList = list.stream()
                .map(WebsiteInfoDO::buildWebsiteRangeDTO)
                .collect(Collectors.toList());
        for (WebsiteRangeDTO websiteRangeDTO : rangeList) {
            for (LocationVO d : websiteRangeDTO.getLocationList()) {
                double distance = 0;
                if (d.getJd() != null && d.getJd() != 0 && d.getWd() != null && d.getWd() != 0) {
                    distance = LocationUtils.getDistance(d.getWd(), d.getJd(), lat, lon);
                }
                d.setRange(distance);
            }
            websiteRangeDTO.getLocationList().sort(Comparator.comparing(LocationVO::getRange));
        }
        return ResultBody.success(rangeList);
    }

    @Override
    public ResultBody getProvinceWebsiteRange(WebsiteVO websiteVO) {
        WebsiteInfoDO website = websiteDao.getWebsiteByAdCode(websiteVO.getAdCode());
        WebsiteRangeDTO websiteRangeDTO = website.buildWebsiteRangeDTO();
        // 获取位置信息
        List<LocationVO> locationList = websiteRangeDTO.getLocationList();
        for (LocationVO d : locationList) {
            double distance = 0;
            if (d.getJd() != null && d.getJd() != 0 && d.getWd() != null && d.getWd() != 0) {
                distance = LocationUtils.getDistance(d.getWd(), d.getJd(), websiteVO.getLat(), websiteVO.getLon());
            }
            d.setRange(distance);
        }
        locationList.sort(Comparator.comparing(LocationVO::getRange));
        return ResultBody.success(locationList);
    }
}
