package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.IndustryCaseVO;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.service.IndustryCaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/5/19 11:34
 */
@Api(tags = {"业务案例相关"})
@RestController
@RequestMapping("/industry-case/")
public class IndustryCaseController {
    @Autowired
    private IndustryCaseService industryCaseService;

    @ApiOperation(value = "案例列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @PostMapping("listCasePage")
    public ResultBody listCasePage(@Validated(value = {Page.class})@RequestBody IndustryCaseQO industryCaseQO){
        return industryCaseService.listCasePage(industryCaseQO);
    }

    @ApiOperation(value = "案例详情")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @GetMapping("details")
    public ResultBody details(@RequestParam Integer id){
        return industryCaseService.details(id);
    }
}
