package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.FlowDictionaryDTO;
import com.mmc.csf.infomation.dto.ServiceArriveSceneDTO;
import com.mmc.csf.infomation.dto.ServiceFulfilATaskDTO;
import com.mmc.csf.infomation.dto.ServiceSettleAccountsDTO;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.MyPreemptQO;
import com.mmc.csf.infomation.qo.MyPublishQO;
import com.mmc.csf.infomation.vo.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
public interface RequirementsService {
    /**
     * 需求类型列表
     *
     * @return
     */
    ResultBody listType(Integer id);

    /**
     * 需求发布
     *
     * @param requirementsInfoVO
     * @param request
     * @return
     */
    ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request);

    /**
     * 解决需求
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId);

    /**
     * 需求发布列表
     *
     * @param industryCaseQO
     * @param request
     * @return
     */
    ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request);

    /**
     * 删除需求
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId);

    ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request);

    ResultBody deletePublish(Integer id, Integer userAccountId);

    ResultBody appPublishList();

    ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId);

    ResultBody backDetailPublish(Integer id, HttpServletRequest request, Integer userAccountId);

    ResultBody publishService(ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request);

    PageResult myPublish(Integer userAccountId, MyPublishQO param);

    ResultBody<RequirementsInfoVO> grabTheOrder(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request);

    ResultBody arriveAtTheScene(ServiceArriveSceneVO serviceArriveSceneVO);

    ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody fulfilATask(ServiceFulfilATaskVO fulfilATaskVO);

    ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody settleAccounts(ServiceSettleAccountsVO settleAccountsVO);


    ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody evaluate(ServiceEvaluateVO evaluateVO);

    ResultBody evaluateDetails(Integer requirementsInfoId, Integer userAccountId);

    ResultBody publisherNumber(GetOrderNumberVO getOrderNumberVO, HttpServletRequest request);

    PageResult myPreempt(Integer userAccountId, MyPreemptQO param);

    ResultBody droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request);

    ResultBody publisherCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request);

    ResultBody cancelAll(Integer requirementsInfoId, Integer userAccountId);


    ResultBody updatePublisherCancel(RequirementsAmountVO amountVO, HttpServletRequest request);

    ResultBody<FlowDictionaryDTO> flowDictionary();

    ResultBody confirmSettlement(Integer userAccountId, Integer requirementsInfoId);

    ResultBody orderRequirements(String format);
}
