package com.mmc.csf.infomation.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

/**
 * @Author small
 * @Date 2023/8/18 21:58
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceEvaluateVO {
    @ApiModelProperty(value = "需求id", example = "83")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "完成任务的用户", example = "1", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "评价内容", example = "1")
    @Length(max = 300, message = "字符过长")
    private String evaluationContent;

    @ApiModelProperty(value = "星级", example = "星")
    private String starLevel;

    @ApiModelProperty(value = "评价图片", example = "星")
    private String evaluationUrl;


}
