package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.forum.vo.CommentAndReplyVO;
import com.mmc.csf.release.forum.vo.CommentVO;
import com.mmc.csf.release.forum.vo.DynamicVO;

import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:29
 * 概要：动态信息service层
 */
public interface DynamicService {
    /**
     * 插入动态
     *
     * @param dynamicVO 动态
     * @return {@link ResultBody}
     */
    ResultBody insertDynamic(DynamicVO dynamicVO,Integer userAccountId);

    /**
     * 点赞动态
     *
     * @param userId    用户id
     * @param dynamicId 动态id
     * @return {@link ResultBody}
     */
    ResultBody likeDynamic(Integer userId, Integer dynamicId);

    /**
     * 评论动态
     *
     * @param commentVO 评论信息
     * @return {@link ResultBody}
     */
    ResultBody commentDynamic(CommentVO commentVO,Integer userAccountId);

    /**
     * 删除评论
     *
     * @param id id
     * @return {@link ResultBody}
     */
    ResultBody deleteComment(Integer id);

    /**
     * 根据动态查看评论
     *
     * @param dynamicId 动态id
     * @return {@link List}<{@link CommentVO}>
     */
    List<CommentAndReplyVO> getCommentAndReply(Integer dynamicId);

    /**
     * 动态列表
     *
     * @param pageNo   页面
     * @param pageSize 页面大小
     * @param userId
     * @return {@link List}<{@link DynamicVO}>
     */
    PageResult dynamicList(Integer pageNo, Integer pageSize, Integer userId);

    /**
     * 动态细节
     *
     * @param dynamicId 动态id
     * @param userId    用户id
     * @return {@link ResultBody}
     */
    ResultBody dynamicDetails(Integer dynamicId, Integer userId);
}
