package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.math.CodeUtil;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.redis.RedisConstant;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.release.dao.TaskDao;
import com.mmc.csf.release.entity.IndustryDO;
import com.mmc.csf.release.entity.InspComtDO;
import com.mmc.csf.release.entity.InspectionDO;
import com.mmc.csf.release.entity.TaskOrderDO;
import com.mmc.csf.release.service.TaskService;
import com.mmc.csf.release.task.qo.TaskServiceQo;
import com.mmc.csf.release.task.vo.IndustryVO;
import com.mmc.csf.release.task.vo.OrderTaskVO;
import com.mmc.csf.release.task.vo.TaskServiceDetailVO;
import com.mmc.csf.release.task.vo.TaskServiceVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/5/17 13:56
 * 概要：作业服务实现层
 */
@Service
public class TaskServiceImpl implements TaskService {
    @Resource
    private TaskDao taskDao;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public PageResult queryTaskServiceList(TaskServiceQo taskServiceQo) {
        Integer SZ = 440300;
        if (taskServiceQo.getRegionId() != null && taskServiceQo.getRegionId().equals(SZ)) {
            return PageResult.buildPage(taskServiceQo.getPageNo(), taskServiceQo.getPageSize(), 0);
        }
        int count = taskDao.countTaskServiceList(taskServiceQo);
        if (count == 0) {
            return PageResult.buildPage(taskServiceQo.getPageNo(), taskServiceQo.getPageSize(), count);
        }
        Integer pageNo = taskServiceQo.getPageNo();
        taskServiceQo.buildCurrentPage();
        List<InspectionDO> inspectionList = taskDao.listPageTaskService(taskServiceQo);
        List<TaskServiceVO> list = inspectionList.stream().map(InspectionDO::buildTaskService).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, taskServiceQo.getPageSize(), count, list);
    }


    @Override
    public ResultBody getInspectionById(Integer id) {
        InspectionDO inspectionDO = taskDao.selectInspectionById(id);
        if (inspectionDO == null) {
            return ResultBody.error("作业服务不存在");
        }
        TaskServiceDetailVO taskServiceDetailVO = inspectionDO.buildTaskServiceDetailVO();

        String key = RedisConstant.createInspection(id);
        Boolean isExist = redisTemplate.hasKey(key);
        if (!isExist) {
            // 获取评论
            int size = (int) (100 * Math.random() + 98);
            List<InspComtDO> evaluateInfoList = taskDao.getEvaluateInfoList(size);
            String toJSONString = JSONObject.toJSONString(evaluateInfoList);
            redisTemplate.opsForValue().set(key, toJSONString, 2L, TimeUnit.DAYS);
            taskServiceDetailVO.setEvaluateInfo(evaluateInfoList.stream().map(InspComtDO::buildEvaluateInfoVO).collect(Collectors.toList()));
            taskServiceDetailVO.setItem(evaluateInfoList.size());
        } else {
            String listStr = (String) redisTemplate.opsForValue().get(key);
            List<InspComtDO> array = JSONArray.parseArray(listStr, InspComtDO.class);
            taskServiceDetailVO.setEvaluateInfo(array.stream().map(InspComtDO::buildEvaluateInfoVO).collect(Collectors.toList()));
            taskServiceDetailVO.setItem(array.size());
        }
        return ResultBody.success(taskServiceDetailVO);
    }

    @Override
    public ResultBody reservationService(OrderTaskVO orderTaskVO) {
        Integer count = taskDao.getIndustryAndInspect(orderTaskVO.getIndustryId(), orderTaskVO.getInspectionId());
        if (count == 0) {
            return ResultBody.error(ResultEnum.INSPECTION_NOT_EXIST);
        }
        InspectionDO inspectionDO = taskDao.getInspectionById(orderTaskVO.getInspectionId());
        if (inspectionDO == null) {
            return ResultBody.error(ResultEnum.INSPECTION_NOT_EXIST);
        }
        TaskOrderDO taskOrderDo = new TaskOrderDO(orderTaskVO);
        if (CollectionUtils.isNotEmpty(orderTaskVO.getFilePath())) {
            taskOrderDo.setImageUrl(String.join(",", orderTaskVO.getFilePath()));
        }
        taskOrderDo.setUserAccountId(1);
        taskOrderDo.defaultInfo();
        taskOrderDo.setOrderNo(CodeUtil.createOrderTaskNO());
        taskOrderDo.setOrderName(inspectionDO.getName());
        taskDao.insertOrderTask(taskOrderDo);
        return ResultBody.success();
    }


    @Override
    public ResultBody listAllIndustry() {
        //查找所有服务
        List<IndustryVO> collect = taskDao.listAllIndustry()
                .stream().map(IndustryDO::buildIndustryVO)
                .collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody listAllAppType() {

        return ResultBody.success(taskDao.listAllAppType());
    }

    @Override
    public ResultBody listAllTaskService() {
        List<InspectionDO> inspectionList = taskDao.listAllTaskService();
        return ResultBody.success(inspectionList.stream().map(InspectionDO::buildTaskService).collect(Collectors.toList()));
    }
}
