package com.mmc.csf.common.util.other;

/**
 * @author 作者 geDuo
 * @version 创建时间：2021年11月5日 下午5:48:59
 * @explain 高德地图对应经纬度计算距离
 */
public class LocationUtils {
	// 地球赤道半径
	private static double EARTH_RADIUS = 6378.137;

	private static double rad(double d) {
		return d * Math.PI / 180.0;
	}

	/**
	 * @描述 经纬度获取距离，单位为KM
	 * @参数 [lat1, lon1, lat2, lon2]
	 * @返回值 double
	 * @创建人 Young
	 * @创建时间 2019/3/13 20:33
	 **/
	public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
		double radLat1 = rad(lat1);
		double radLat2 = rad(lat2);
		double a = radLat1 - radLat2;
		double b = rad(lon1) - rad(lon2);
		double s = 2 * Math.asin(Math.sqrt(
				Math.pow(Math.sin(a / 2), 2) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2), 2)));
		s = s * EARTH_RADIUS;
		s = Math.round(s * 10000d) / 10000d;
		return s;
	}

	public static double getDistanceByM(double lat1, double lon1, double lat2, double lon2) {
		double s = LocationUtils.getDistance(lat1, lon1, lat2, lon2) * 1000;
		return s;
	}

	public static void main(String[] args) {
		double distance = getDistance(34.810487, 117.323725, 22.576802, 113.94059);
		System.out.println("距离" + distance + "KM");
    }
}
