package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.service.FlyerTrainingService;
import com.mmc.csf.release.vo.DronePilotLicenseVO;
import com.mmc.csf.release.vo.FlightSkillsVO;
import com.mmc.csf.release.vo.RegistrationVO;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


/**
 * @Author LW
 * @date 2023/5/13 11:00
 * 概要：
 */
@Api(tags = {"web-小程序-飞手培训-模块"})
@RestController
@RequestMapping("/curriculum/")
public class FlyerTrainingController {

    @Resource
    private FlyerTrainingService flyerTrainingService;

    @ApiOperation(value = "飞手报名")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/pilotRegistration")
    public ResultBody pilotRegistration(@RequestBody RegistrationVO registrationVO, @ApiParam(value = "模拟用户id") Integer id) {
        return flyerTrainingService.pilotRegistration(registrationVO, id);
    }


    @ApiOperation(value = "无人机驾驶员执照-树形图")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DronePilotLicenseVO.class)})
    @GetMapping("/getDronePilotLicense")
    public ResultBody getDronePilotLicense() {
        return flyerTrainingService.getDronePilotLicense();
    }

    @ApiOperation(value = "行业应用认证-下拉列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = FlightSkillsVO.class)})
    @GetMapping("/getIndustryFlightSkills")
    public ResultBody getIndustryFlightSkills() {
        return flyerTrainingService.getIndustryFlightSkills();
    }
}
