package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.forum.vo.CommentAndReplyVO;
import com.mmc.csf.forum.vo.CommentVO;
import com.mmc.csf.forum.vo.DynamicVO;
import com.mmc.csf.release.service.DynamicService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/5/15 10:29
 * 概要：动态信息控制层
 */
@Api(tags = {"web-小程序-论坛社区-模块"})
@RestController
@RequestMapping("/dynamic")
public class DynamicController {

    @Resource
    private DynamicService dynamicService;

    @ApiOperation(value = "动态发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/publish")
    public ResultBody publishDynamic(@RequestBody DynamicVO dynamicVO) {
        return dynamicService.insertDynamic(dynamicVO);
    }

    @ApiOperation(value = "点赞或取消点赞")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/likeOrCancel")
    public ResultBody likeOrCancel(@ApiParam(value = "模拟用户id") @RequestParam Integer userId, @ApiParam(value = "动态id") @RequestParam Integer dynamicId) {
        return dynamicService.likeDynamic(userId, dynamicId);
    }

    @ApiOperation(value = "评论动态或回复评论")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/comment")
    public ResultBody commentDynamic(@RequestBody CommentVO commentVO) {
        return dynamicService.commentDynamic(commentVO);
    }

    @ApiOperation(value = "删除评论")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @DeleteMapping("/removeComment")
    public ResultBody removeComment(@RequestParam Integer id) {
        return dynamicService.deleteComment(id);
    }

    @ApiOperation(value = "根据动态查看评论")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CommentAndReplyVO.class)})
    @GetMapping("/byDynamic")
    public ResultBody getCommentsByDynamic(@RequestParam Integer dynamicId) {
        return ResultBody.success(dynamicService.getCommentAndReply(dynamicId));
    }

    @ApiOperation(value = "动态列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DynamicVO.class)})
    @GetMapping("/dynamicList")
    public ResultBody dynamicList(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam Integer userId) {
        return ResultBody.success(dynamicService.dynamicList(pageNo, pageSize,userId));
    }
}
