package com.mmc.csf.release.entity.requirements;

import com.mmc.csf.infomation.dto.PilotCertificationInteriorDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/18 17:23
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsServiceDO implements Serializable {
    private static final long serialVersionUID = -1811974173256250060L;

    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "服务需求id")
    private Integer requirementsInfoId;
    @ApiModelProperty(value = "字典id暂时无用")
    private Integer serviceDictionaryId;

    @ApiModelProperty(value = "抢单飞手id")
    private Integer pilotCertificationId;
    @ApiModelProperty(value = "抢单飞手用户id")
    private Integer pilotCertificationUserId;

    @ApiModelProperty(value = "抢单飞手团队id")
    private Integer teamId;
    @ApiModelProperty(value = "抢单飞手团队用户id")
    private Integer teamUserId;

    @ApiModelProperty(value = "云享金", example = "10")
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10")
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信金额", example = "10")
    private BigDecimal weChat;

    @ApiModelProperty(value = "微信支付订单编号", example = "R202308191657303116170")
    private String wechatPayOrderNumber;

    @ApiModelProperty(value = "抢单支付的总金额", example = "抢单支付的总金额")
    private BigDecimal preemptTotalAmount;
    @ApiModelProperty(value = "任务流程id", example = "任务流程id")
    private Integer serviceFlowId;


    public RequirementsServiceDO(PilotCertificationInteriorDTO pilot, ServiceRequirementsDO requirementsInfoDO) {
        this.pilotCertificationId = pilot.getId();
        this.pilotCertificationUserId = pilot.getUserAccountId();
        this.requirementsInfoId = requirementsInfoDO.getId();
        this.serviceDictionaryId = 2;
    }
}
