package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.commit.NotRepeatSubmit;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.RequirementsService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/18 14:26
 */
@Api(tags = {"需求相关"})
@RestController
@RequestMapping("/requirements/")
public class RequirementsController extends BaseController {

    @Autowired
    private RequirementsService requirementsService;

    @ApiOperation(value = "需求类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsTypeVO.class)})
    @GetMapping("listType")
    public ResultBody listType(@RequestParam(value = "1", required = false) Integer id) {
        return requirementsService.listType(id);
    }

    @ApiOperation(value = "流程字典")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsTypeVO.class)})
    @GetMapping("flowDictionary")
    public ResultBody<FlowDictionaryDTO> flowDictionary() {
        return requirementsService.flowDictionary();
    }


    @ApiOperation(value = "小程序——发布需求信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publish")
    public ResultBody publish(@RequestBody @Validated(value = {Insert.class}) RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        requirementsInfoVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.publish(requirementsInfoVO, request);
    }

    @ApiOperation(value = "小程序——发布服务需求")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publishService")
    public ResultBody publishService(@RequestBody @Validated(value = {Insert.class}) ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request) {
        serviceRequirementsVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.publishService(serviceRequirementsVO, request);
    }


    @ApiOperation(value = "new——小程序发布服务-——抢单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @NotRepeatSubmit(value = 3000L)
    @PostMapping("grabTheOrder")
    public ResultBody grabTheOrder(@RequestBody GrabTheOrderVO grabTheOrderVO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        grabTheOrderVO.setUserAccountId(userAccountId);
        return requirementsService.grabTheOrder(grabTheOrderVO, request);
    }


    @ApiOperation(value = "小程序——发布服务需求订单编号单独接口")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publisherNumber")
    public ResultBody<GetOrderNumberDTO> publisherNumber(@RequestBody GetOrderNumberVO getOrderNumberVO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        getOrderNumberVO.setUserAccountId(userAccountId);
        return requirementsService.publisherNumber(getOrderNumberVO, request);
    }


    @ApiOperation(value = "小程序-编辑——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePublish")
    public ResultBody updatePublish(@RequestBody @Validated(value = {Update.class}) RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        requirementsInfoVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.updatePublish(requirementsInfoVO, request);
    }

    @ApiOperation(value = "小程序-删除——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deletePublish")
    public ResultBody deletePublish(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer id, HttpServletRequest request) {
        return requirementsService.deletePublish(id, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "小程序-列表——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("appPublishList")
    public ResultBody<RequirementsInfoVO> appPublishList() {
        return requirementsService.appPublishList();
    }


    @ApiOperation(value = "小程序-详情——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("detailPublish")
    public ResultBody<RequirementsInfoVO> detailPublish(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer id, HttpServletRequest request) {
        return requirementsService.detailPublish(id, request, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "new——小程序-—服务订单--我的发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("myPublish")
    public ResultBody<RequirementsInfoVO> myPublish(HttpServletRequest request) {
        return requirementsService.myPublish(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "new——小程序-—服务订单--我的抢单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("myPreempt")
    public ResultBody<RequirementsInfoVO> myPreempt(HttpServletRequest request) {
        return requirementsService.myPreempt(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "new——小程序-—飞手端--抵达现场")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("arriveAtTheScene")
    public ResultBody arriveAtTheScene(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceArriveSceneVO serviceArriveSceneVO) {
        serviceArriveSceneVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.arriveAtTheScene(serviceArriveSceneVO);
    }


    @ApiOperation(value = "new——小程序-—飞手端--抵达现场详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("arriveAtTheSceneDetails")
    public ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.arriveAtTheSceneDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—飞手端--完成任务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("fulfilATask")
    public ResultBody fulfilATask(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceFulfilATaskVO fulfilATaskVO) {
        fulfilATaskVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.fulfilATask(fulfilATaskVO);
    }


    @ApiOperation(value = "new——小程序-—飞手端--完成任务详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("fulfilATaskDetails")
    public ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.fulfilATaskDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—发布者--订单结算")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("settleAccounts")
    public ResultBody settleAccounts(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceSettleAccountsVO settleAccountsVO) {
        settleAccountsVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.settleAccounts(settleAccountsVO);
    }


    @ApiModelProperty(value = "new--小程序————飞手端确认结算")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("confirmSettlement")
    public ResultBody confirmSettlement(HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.confirmSettlement(userAccountId);
    }

    @ApiOperation(value = "new——小程序-—发布者--订单结算详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("settleAccountsDetails")
    public ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.settleAccountsDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—发布者对飞手--评价")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("evaluate")
    public ResultBody evaluate(HttpServletRequest request, @RequestBody @Validated(value = {Insert.class}) ServiceEvaluateVO evaluateVO) {
        evaluateVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return requirementsService.evaluate(evaluateVO);
    }


    @ApiOperation(value = "new——小程序-—发布者对飞手--评价详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("evaluateDetails")
    public ResultBody<ServiceEvaluateDTO> evaluateDetails(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.evaluateDetails(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "new——小程序-—飞手单方便取消订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("droneFlyerCancel")
    public ResultBody droneFlyerCancel(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.droneFlyerCancel(requirementsInfoId, userAccountId);
    }

    @ApiOperation(value = "new——小程序-—发布者单方便取消订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("publisherCancel")
    public ResultBody publisherCancel(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.publisherCancel(requirementsInfoId, userAccountId);
    }

    @ApiOperation(value = "new——小程序-—结算:发布者修改任务佣金")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePublisherCancel")
    public ResultBody updatePublisherCancel(HttpServletRequest request, @RequestBody RequirementsAmountVO amountVO) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        amountVO.setUserAccountId(userAccountId);
        return requirementsService.updatePublisherCancel(amountVO, request);
    }

    @ApiOperation(value = "new——后台管理取消订单(取消发布者与飞手共同建立的订单)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("cancelAll")
    public ResultBody cancelAll(HttpServletRequest request, @ApiParam(value = "发布服务需求id", required = true) @RequestParam Integer requirementsInfoId) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return requirementsService.cancelAll(requirementsInfoId, userAccountId);
    }


    @ApiOperation(value = "后台管理-详情——需求发布")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("backDetailPublish")
    public ResultBody<RequirementsInfoVO> backDetailPublish(@ApiParam(value = "需求发布id", required = true) @RequestParam Integer id, HttpServletRequest request) {
        return requirementsService.backDetailPublish(id, request, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "需求发布列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RequirementsInfoVO.class)})
    @PostMapping("listPublishPage")
    public ResultBody listPublishPage(@Validated(value = {Page.class}) @RequestBody IndustryCaseQO
                                              industryCaseQO, HttpServletRequest request) {
        return requirementsService.listPublishPage(industryCaseQO, request);
    }

    @ApiOperation(value = "需求已解决")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("solveRequire")
    public ResultBody solveRequire(@RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        return requirementsService.solveRequire(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "删除需求")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteRequire")
    public ResultBody deleteRequire(@RequestParam Integer requirementsInfoId, HttpServletRequest request) {
        return requirementsService.deleteRequire(requirementsInfoId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


}
