package com.mmc.csf.infomation.dto;

import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/18 19:56
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceArriveSceneDTO {
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "id")
    private Double longitude;

    @ApiModelProperty(value = "id")
    private Double latitude;

    @ApiModelProperty(value = "现场地址")
    private String sceneAddress;

    @ApiModelProperty(value = "现场地址的url", required = true)
    private String sceneUrl;

    @ApiModelProperty(value = "现场用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "服务需求id", required = true)
    private Integer requirementsInfoId;
}
