package com.mmc.csf.release.dao;

import com.mmc.csf.release.entity.requirements.OrderAmountDetailDO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
* @author Admin
* @description 针对表【order_amount_detail】的数据库操作Mapper
* @createDate 2023-11-27 18:55:19
* @Entity com.mmc.csf.release.entity.requirements.OrderAmountDetailDO
*/
@Mapper
public interface OrderAmountDetailDao {

    int deleteByPrimaryKey(Integer requirementsInfoId);

    /**
     * 新增
     * @param record
     * @return int
     */
    int insert(OrderAmountDetailDO record);

    /**
     * 选择性新增
     * @param record 新增实体类
     * @return int
     */
    int insertSelective(OrderAmountDetailDO record);


    /**
     * 批量新增
     * @param list 新增列表
     */
    void batchInsert(List<OrderAmountDetailDO> list);

    /**
     * 根据订单id查询该订单金额明细
     * @param requirementsInfoId 订单id
     * @return {@link List}<{@link OrderAmountDetailDO}>
     */
    List<OrderAmountDetailDO> selectByPrimaryKey(Integer requirementsInfoId);

    int updateByPrimaryKeySelective(OrderAmountDetailDO record);

    int updateByPrimaryKey(OrderAmountDetailDO record);

}
