package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.entity.curriculum.CurriculumInfoDO;
import com.mmc.csf.release.entity.curriculum.CurriculumOrderDO;
import com.mmc.csf.release.entity.curriculum.CurriculumOrderQO;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.CurriculumClassifyVO;
import com.mmc.csf.release.flyer.vo.CurriculumInfoVO;
import com.mmc.csf.release.flyer.vo.CurriculumPayVO;
import com.mmc.csf.release.flyer.vo.RegistrationVO;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:12
 * 概要：
 */
public interface FlyerTrainingService {
    /**
     * 飞手报名
     *
     * @param registrationVO 注册信息
     * @return {@link ResultBody}
     */
    ResultBody pilotRegistration(RegistrationVO registrationVO, Integer userAccount);

    /**
     * 获取无人机飞行员执照
     *
     * @return {@link ResultBody}
     */
    ResultBody getDronePilotLicense();

    /**
     * 获取行业飞行技能
     *
     * @return {@link ResultBody}
     */
    ResultBody getIndustryFlightSkills();

    /**
     * 查询任务服务列表
     *
     * @param taskServiceQo 任务服务问:
     * @return {@link Object}
     */
    PageResult queryCurriculumInfoList(CurriculumQo taskServiceQo);

    /**
     * 许可证或技能查询课程
     *
     * @param type 类型
     * @return {@link ResultBody}
     */
    ResultBody licenseOrSkillQueryCurriculum(Integer type);

    ResultBody curriculumDetails(Integer id);

    /**
     * 添加课程
     *
     * @param curriculumInfoVO
     */
    Integer addCurriculum(CurriculumInfoVO curriculumInfoVO);

    /**
     * 修改课程
     *
     * @param curriculumInfoVO
     */
    Integer updateCurriculum(CurriculumInfoVO curriculumInfoVO);

    /**
     * 删除课程
     *
     * @param id
     */
    Integer removeCurriculum(Integer id);

    /**
     * 课程列表
     *
     * @return
     */
    ResultBody treeCurriculumSkill();

    /**
     * 根据分类列表查询课程
     *
     * @param categoriesId
     * @return
     */
    List<CurriculumInfoVO> feignCurriculumInfoList(Integer categoriesId);

    int feignCountCurriculumInfo(Integer categoriesId);

    Integer getCurriculumCount();

    /**
     * 添加课程分类
     *
     * @param curriculumClassify
     */
    Integer addCurriculumClassify(CurriculumClassifyVO curriculumClassify);

    /**
     * 修改课程分类
     *
     * @param curriculumClassify
     */
    Integer updateCurriculumClassify(CurriculumClassifyVO curriculumClassify);

    /**
     * 删除课程分类
     *
     * @param oneCourseId 1级课程分类
     * @param twoCourseId 2级课程分类
     */
    ResultBody removeCurriculumClassify(Integer id);

    /**
     * 查询所有的课程分类
     * @return
     */
    ResultBody selectCurriculumClassify();

    /**
     * 根据课程ID查询课程信息
     * @param id
     * @return
     */
    CurriculumInfoDO selectCurriculumInfoById(Integer id);

    /**
     * 购买课程——积分支付
     * @param curriculumOrderDO
     * @return
     */
    Integer curriculumPayByIntegral(CurriculumOrderDO curriculumOrderDO);
    /**
     * 购买课程——金钱支付
     * @param curriculumPayVO
     * @return
     */
    ResultBody curriculumPayByMoney(HttpServletRequest request, CurriculumPayVO curriculumPayVO, Integer accountId);



    /**
     * 分页查询订单列表
     * @param param
     * @return {@link List}<{@link CurriculumOrderDO}>
     */
    ResultBody getCurriculumOrderList(CurriculumOrderQO param);

    /**
     * 删除订单
     * @param id 删除对应订单的id
     * @return {@link ResultBody}
     */
    ResultBody deleteCurriculumOrderInfo(Integer id);
}
