package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.group.Create;
import com.mmc.csf.common.util.group.Page;
import com.mmc.csf.common.util.group.Update;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.AppTenderInfoDTO;
import com.mmc.csf.infomation.dto.TenderApplyDTO;
import com.mmc.csf.infomation.dto.TenderInfoDTO;
import com.mmc.csf.infomation.dto.TenderNewsDTO;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.TenderApplyVO;
import com.mmc.csf.infomation.vo.TenderNewsVO;
import com.mmc.csf.release.service.TenderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 14:26
 */
@Api(tags = {"招标相关"})
@RestController
@RequestMapping("/tender/")
public class TenderController extends BaseController{

    @Autowired
    private TenderService tenderService;

    @ApiOperation(value = "新增招标快讯", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping(value = "news")
    public ResultBody addTenderNews(@RequestPart(value = "file") MultipartFile file,
                                    @RequestPart TenderNewsVO tenderNewsVO)
            throws IOException {
        return tenderService.addTenderNews(file, tenderNewsVO);
    }

    @ApiOperation(value = "查询招标快讯列表-分页", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TenderNewsDTO.class)})
    @GetMapping(value = "news")
    public ResultBody listTenderNews(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                                     @RequestParam(value = "tenderName", required = false) String tenderName,
                                     @RequestParam(value = "startTime", required = false) Date startTime,
                                     @RequestParam(value = "endTime", required = false) Date endTime,
                                     @RequestParam(value = "using", required = false)Integer using){
        return tenderService.listTenderNews(pageNo, pageSize, tenderName, startTime, endTime, using);
    }

    @ApiOperation(value = "修改招标快讯列表", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PutMapping(value = "news")
    public ResultBody updateTenderNews(@RequestParam(value = "file", required = false) MultipartFile file,
                                       @Validated(value = {Update.class}) @RequestPart TenderNewsVO tenderNewsVO) throws IOException {
        return tenderService.updateTenderNews(file, tenderNewsVO);
    }

    @ApiOperation(value = "删除查询招标快讯", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @DeleteMapping(value = "news/{id}")
    public ResultBody removeTenderNews(@PathVariable("id") Integer id){
        return tenderService.removeTenderNews(id);
    }

    @ApiOperation(value = "查询招标快讯详情列表-分页", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TenderInfoDTO.class)})
    @GetMapping(value = "info")
    public ResultBody listTenderInfo(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                                     @RequestParam Integer tenderNewsId){
        return tenderService.listTenderInfo(pageNo, pageSize, tenderNewsId);
    }

    @ApiOperation(value = "修改招标快讯详情", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PutMapping(value = "info")
    public ResultBody updateTenderInfo(@RequestParam(value = "id", required = true) Integer id,
                                       @RequestParam(value = "tenderContent", required = true) String tenderContent,
                                       @RequestParam(required = false)BigDecimal tenderPrice){
        return tenderService.updateTenderInfo(id, tenderContent, tenderPrice);
    }

    @ApiOperation(value = "合作申请提交")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping(value = "apply")
    public ResultBody addTenderApply(@Validated(value = {Create.class})@RequestBody TenderApplyVO tenderApplyVO, HttpServletRequest request){
        tenderApplyVO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
        return tenderService.addTenderApply(tenderApplyVO);
    }

    @ApiOperation(value = "用户反馈列表-分页", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = TenderApplyDTO.class)})
    @GetMapping(value = "apply")
    public ResultBody listTenderApply(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                                      @RequestParam Integer tenderNewsId, @RequestParam(required = false) Integer tenderInfoId,
                                      @RequestParam(required = false) String keyword){
        return tenderService.listTenderApply(pageNo, pageSize, tenderNewsId, tenderInfoId, keyword);
    }

    @ApiOperation(value = "app往期招标快讯详情列表-分页", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppTenderInfoDTO.class)})
    @GetMapping(value = "info/app")
    public ResultBody listTenderInfoApp(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                                        @RequestParam Integer tenderNewsId, @RequestParam(required = false) Integer userAccountId){
        return tenderService.listTenderInfoApp(pageNo, pageSize, tenderNewsId, userAccountId);
    }

    @ApiOperation(value = "app最新招标快讯详情列表-分页", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppTenderInfoDTO.class)})
    @GetMapping(value = "info/app/latest")
    public ResultBody listTenderInfoAppLatest(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                                              @RequestParam(required = false) Integer userAccountId){
        return tenderService.listTenderInfoAppLatest(pageNo, pageSize, userAccountId);
    }

    @ApiOperation(value = "招投标列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppTenderInfoDTO.class)})
    @PostMapping(value = "listNewTenderInfo")
    public ResultBody listNewTenderInfo(@Validated(value = {Page.class})@RequestBody IndustryCaseQO industryCaseQO, HttpServletRequest request){
        return tenderService.listNewTenderInfo(industryCaseQO, this.getUserLoginInfoFromRedis(request));
    }

}
