package com.mmc.csf.release.entity;

import com.mmc.csf.infomation.vo.IndustryNewsVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/19 11:20
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryNewsDO implements Serializable {
    private static final long serialVersionUID = 3296973167970903480L;
    private Integer id;
    private String newsTitle;
    private String newsAuthor;
    private Integer userAccountId;
    private String surfaceImg;
    private String newsContents;
    private Date createTime;
    private Date updateTime;

    public IndustryNewsVO buildIndustryNewsVO(){
        return IndustryNewsVO.builder().id(id).newsTitle(newsTitle).newsAuthor(newsAuthor).userAccountId(userAccountId).surfaceImg(surfaceImg).
                newsContents(newsContents).createTime(createTime).updateTime(updateTime).build();
    }

    public IndustryNewsDO(IndustryNewsVO industryNewsVO){
        this.id = industryNewsVO.getId();
        this.newsTitle = industryNewsVO.getNewsTitle();
        this.newsAuthor = industryNewsVO.getNewsAuthor();
        this.userAccountId = industryNewsVO.getUserAccountId();
        this.surfaceImg = industryNewsVO.getSurfaceImg();
        this.newsContents = industryNewsVO.getNewsContents();
    }
}
