package com.mmc.csf.release.dao;

import com.mmc.csf.release.entity.curriculum.*;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.DronePilotLicenseVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 11:34
 * 概要：
 */
@Mapper
public interface FlyerTrainingDao {

    /**
     * 插入飞手报名登记信息
     *
     * @param pilotRegistrationDO 飞行员信息登记
     */
    void insertPilotRegistrationInfo(PilotRegistrationDO pilotRegistrationDO);

    List<DronePilotLicenseVO> selectAllLicenses();

    /**
     * 课程技能列表
     *
     * @return {@link List}<{@link FlightSkillsDO}>
     */
    List<FlightSkillsDO> listIndustryFlightSkills();

    int countCurriculumInfoList(CurriculumQo curriculumQo);

    /**
     * 课程信息列表页面
     *
     * @param curriculumQo 课程问:
     * @return {@link List}<{@link CurriculumInfoDO}>
     */
    List<CurriculumInfoDO> listPageCurriculumInfo(CurriculumQo curriculumQo);

    /**
     * 查询考证视频
     *
     * @return {@link List}<{@link CurriculumInfoDO}>
     */
    List<CurriculumInfoDO> selectLicensesCurriculum();

    /**
     * 查询技能课程
     *
     * @param type 类型
     * @return {@link List}<{@link CurriculumInfoDO}>
     */
    List<CurriculumInfoDO> selectSkillCurriculum(Integer type);

    CurriculumInfoDO curriculumDetails(Integer id);

    /**
     * 添加课程信息
     *
     * @param currInfoDO
     */
    Integer addCurriculum(CurriculumInfoDO currInfoDO);

    /**
     * 修改课程信息
     *
     * @param currInfoDO
     */
    Integer updateCurriculum(CurriculumInfoDO currInfoDO);

    /**
     * 删除课程
     *
     * @param id
     */
    Integer removeCurriculum(Integer id);

    /**
     * 课程技能列表
     *
     * @return
     */
    List<FlightSkillsDO> treeCurriculumSkill();

    int countCurriculumInfo(Integer categoriesId);

    Integer getCurriculumCount();

    /**
     * 添加课程分类
     *
     * @param curriculumClassifyDO
     */
    Integer addCurriculumClassify(CurriculumClassifyDO curriculumClassifyDO);

    /**
     * 修改课程分类
     *
     * @param curriculumClassify
     */
    Integer updateCurriculumClassify(CurriculumClassifyDO curriculumClassify);

    /**
     * 删除课程分类
     *
     * @param id 课程分类id
     */
    Integer removeCurriculumClassify(Integer id);

    /**
     * 查询一级分类的数量
     * @return
     */
    Integer countOneCourseClassify();

    /**
     * 查询当前一级分类下的二级分类的数量
     * @param twoCourseId 2级课程分类
     */
    Integer countTwoCourseClassify(Integer twoCourseId);

    /**
     * 查询所有的课程分类
     * @return
     */
    List<CurriculumClassifyDO> selectCurriculumClassify();

    CurriculumClassifyDO selectCurriculumClassifyById(Integer id);

    /**
     * 根据课程ID查询课程信息
     * @return
     */
    CurriculumInfoDO selectCurriculumInfoById(Integer id);

    int selectCountCurriculumOrder(Integer id,Integer userId);

    int insertCurriculumOrder(CurriculumOrderDO record);

    CurriculumInfoDO queryCurriculumInfoById(Integer id);
}
