package com.mmc.csf.release.entity.tender;

import com.mmc.csf.infomation.dto.TenderApplyDTO;
import com.mmc.csf.infomation.vo.TenderApplyVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2022/5/21
 * time:16:02
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TenderApplyDO implements Serializable {
    private static final long serialVersionUID = 4290565153507919210L;
    private Integer id;
    private Integer userAccountId;
    private Integer tenderInfoId;
    private String nickName;
    private String userName;
    private String phoneNum;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    private String tenderInfoNo;
    private String tenderTitle;

    public TenderApplyDO(TenderApplyVO tenderApplyVO) {
        this.userAccountId = tenderApplyVO.getUserAccountId();
        this.tenderInfoId = tenderApplyVO.getTenderInfoId();
        this.nickName = tenderApplyVO.getNickName();
        this.userName = tenderApplyVO.getUserName();
        this.phoneNum = tenderApplyVO.getPhoneNum();
    }

    public TenderApplyDTO buildTenderApplyDTO(){
        return TenderApplyDTO.builder().id(this.id).tenderInfoId(this.tenderInfoId).nickName(this.nickName).userName(this.userName).phoneNum(this.phoneNum)
                .createTime(this.createTime).tenderInfoNo(this.tenderInfoNo).tenderTitle(this.tenderTitle).build();
    }
}
