package com.mmc.csf.release.entity.requirements;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mmc.csf.config.IsNullConvertZero;
import com.mmc.csf.infomation.vo.RequirementsAmountVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/26 14:18
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsAmountUpdateDO {
    private Integer id;

    @ApiModelProperty(value = "服务需求id", example = "1")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "发布者订单金额", example = "100")
    @IsNullConvertZero
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "发布者修改后订单金额", example = "100")
    @IsNullConvertZero
    private BigDecimal updateOrderAmount;

    @ApiModelProperty(value = "需要支付的云享金", example = "100")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "微信支付金额", example = "100")
    @IsNullConvertZero
    private BigDecimal weChat;

    @ApiModelProperty(value = "佣金", example = "100")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信支付的订单编号", example = "100")
    private String wechatPayOrderNumber;

    @ApiModelProperty(value = "修改原因", example = "未按时完成任务")
    private String reason;

    @ApiModelProperty(value = "图片地址", example = "http://")
    private String url;

    @ApiModelProperty(value = "用户id", example = "1")
    private Integer userAccountId;

    @ApiModelProperty(value = "需要退回金额", example = "100")
    @IsNullConvertZero
    private BigDecimal returnCashAmount;

    @ApiModelProperty(value = "需要退回微信金额")
    @IsNullConvertZero
    private BigDecimal returnWeChat;

    @ApiModelProperty(value = "需要退回佣金")
    @IsNullConvertZero
    private BigDecimal returnSalaryAmount;

    @ApiModelProperty(value = "小程序是否支付修改后金额 1,支付了 0,后台修改未支付")
    @JsonIgnore
    private Integer userSureChange;

    public RequirementsAmountUpdateDO(RequirementsAmountVO amountVO, RequirementsInfoDO requirementsInfoDO) {
        this.updateOrderAmount = amountVO.getUpdateOrderAmount();
        this.reason = amountVO.getReason();
        this.url = amountVO.getUrl();
        this.userAccountId = amountVO.getUserAccountId();
        this.orderAmount = requirementsInfoDO.getOrderAmount();
        this.requirementsInfoId = requirementsInfoDO.getId();

    }


}
