package com.mmc.csf.forum.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.io.Serializable;

/**
 * 评论表(ForumCommentDO)实体类
 *
 * @author lw
 * @since 2023-05-16 09:54:25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumCommentDO implements Serializable {
    private static final long serialVersionUID = 768897358613182410L;
    /**
     * 评论id
     */
    private Integer id;
    /**
     * 用户id，外键，关联user表
     */
    private Integer userId;
    /**
     * 动态id，外键，关联dynamic表
     */
    private Integer dynamicId;
    /**
     * 评论内容
     */
    private String content;
    /**
     * 点赞数量
     */
    private Integer likesCount;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 是否删除，0表示未删除，1表示已删除
     */
    private Integer deleted;
}

