package com.mmc.csf.forum.dao;

import com.mmc.csf.forum.entity.ForumCommentDO;
import com.mmc.csf.forum.vo.CommentAndReplyVO;
import com.mmc.csf.forum.vo.CommentVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:29
 * 概要：动态评论数据访问层
 */
@Mapper
public interface CommentDAO {

    /**
     * 插入评论
     *
     * @param userId    用户id
     * @param dynamicId 动态id
     * @param content   内容
     */
    void insertComment(@Param("userId") int userId, @Param("dynamicId") int dynamicId, @Param("content") String content);

    /**
     * 删除评论
     *
     * @param id id
     * @return int
     */
    int deleteComment(int id);

    /**
     * 插入回复评论
     *
     * @param userId    用户id
     * @param dynamicId 动态id
     * @param content   内容
     * @param parentId  父id
     */
    void insertReplyComment(@Param("userId") int userId, @Param("dynamicId") int dynamicId, @Param("content") String content, @Param("parentId") Integer parentId);

    /**
     * 查询评论列表
     *
     * @param dynamicId 动态id
     * @return {@link List}<{@link CommentAndReplyVO}>
     */
    List<CommentAndReplyVO> selectCommentList(@Param("dynamicId") Integer dynamicId);

    /**
     * 查询子评论列表
     *
     * @param parentIds 父id
     * @return {@link List}<{@link CommentVO}>
     */
    List<CommentVO> selectSubCommentList(List<Integer> parentIds);
}
