package com.mmc.csf.release.util;

import com.mmc.csf.infomation.vo.PersonSendOrderVO;
import com.mmc.csf.release.dao.RequirementsDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.TimerTask;

@Component
public class MyTask extends TimerTask implements Serializable {
    private final RequirementsDao requirementsDao;
    private PersonSendOrderVO personSendOrderVO;

    public MyTask(RequirementsDao requirementsDao) {
        this.requirementsDao = requirementsDao;
    }

    public void setPersonSendOrderVO(PersonSendOrderVO personSendOrderVO) {
        this.personSendOrderVO = personSendOrderVO;
    }

    private static final long serialVersionUID = 1L;

    @Override
    public void run() {
        requirementsDao.deleteSendOrder(personSendOrderVO.getRequirementsInfoId());
        System.out.println("定时任务执行完毕！");
    }
}

