package com.mmc.csf.release.entity.forum;

import com.mmc.csf.release.forum.vo.ReplyToAReviewVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/9/16 17:37
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ForumTwoLevelReviewDO implements Serializable {

    private static final long serialVersionUID = 570379773690905364L;

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "二级评论点赞数")
    private Integer firstLikeCount;

    @ApiModelProperty(value = "动态id",example = "172")
    private Integer dynamicId;

    @ApiModelProperty(value = "评论内容",example = "内容")
    private String content;

    @ApiModelProperty(value = "被回复者用户id")
    private Integer replyUserAccountId;

    @ApiModelProperty(value = "被回复的一级用户")
    private Integer replyOneUserAccountId;

    @ApiModelProperty(value = "被回复的二级用户")
    private Integer replyTwoUserAccountId;

    public ForumTwoLevelReviewDO(ReplyToAReviewVO replyToAReviewVO){
        this.dynamicId=replyToAReviewVO.getDynamicId();
        this.content=replyToAReviewVO.getContent();
        this.replyUserAccountId=replyToAReviewVO.getReplyUserAccountId();
        this.replyOneUserAccountId=replyToAReviewVO.getReplyOneUserAccountId();
        this.replyTwoUserAccountId=replyToAReviewVO.getReplyTwoUserAccountId();
    }



}
