package com.mmc.csf.licence.qo;

import com.mmc.csf.release.model.group.Freeze;
import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/7/14 16:58
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LicenseOrganizationsQO {

    @ApiModelProperty(value = "机构名称不能为空", example = "科比特智能教育", required = false)
    private String name;

    @ApiModelProperty(value = "培训等级id", example = "1", required = false)
    private Integer gradeId;

    @ApiModelProperty(value = "培训机型id", example = "1", required = false)
    private Integer modelsId;

    @ApiModelProperty(value = "培训类型id", example = "1", required = false)
    private Integer typeId;

    @ApiModelProperty(value = "开始时间,如果只有一个日期,就开始时间与结束时间一致", example = "2023-07-14", required = false)
    private String startTime;

    @ApiModelProperty(value = "结束时间", example = "2023-07-14", required = false)
    private String endTime;

    @ApiModelProperty(value = "机构id", example = "1", required = false)
    private Integer id;

    @ApiModelProperty(value = "地域region", example = "110000", required = false)
    private String region;

    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

}
