package com.mmc.csf.release.entity;

import com.mmc.csf.infomation.dto.TenderNewsDTO;
import com.mmc.csf.infomation.vo.TenderNewsVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2022/5/21
 * time:15:56
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TenderNewsDO implements Serializable {
    private static final long serialVersionUID = 3403042130524788589L;
    private Integer id;
    private String tenderName;
    private Integer using;
    private Integer port;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public TenderNewsDTO buildTenderNewsDTO(){
        return TenderNewsDTO.builder().id(this.id).tenderName(this.tenderName).using(this.using).port(this.port).createTime(this.createTime)
                .build();
    }

    public TenderNewsDO(TenderNewsVO tenderNewsVO){
        this.id = tenderNewsVO.getId();
        this.tenderName = tenderNewsVO.getTenderName();
        this.using = tenderNewsVO.getUsing();
        this.port = tenderNewsVO.getPort();
    }
}
