package com.mmc.csf.licence.vo;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @Author small
 * @Date 2023/7/14 11:12
 * @Version 1.0
 */
@Data
public class LicenseTrainingProgramsVO {

    private static final long serialVersionUID = -5814724843819090363L;
    @ApiModelProperty(value = "培训id", example = "1")
   // @NotNull(message = "培训id不能为空", groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "培训等级id", example = "1", required = true)
    @NotNull(message = "培训等级id不能为空", groups = {Create.class, Update.class})
    @Max(value = 2,  groups = {Create.class, Update.class},message = "培训等级id不能超过2")
    private Integer gradeId;

    @ApiModelProperty(value = "培训机型id", example = "1", required = true)
    @NotNull(message = "培训机型id不能为空", groups = {Create.class, Update.class})
    @Max(value = 4,  groups = {Create.class, Update.class},message = "培训机型id不能超过4")
    private Integer modelsId;

    @ApiModelProperty(value = "培训类型id", example = "1", required = true)
    @NotNull(message = "培训类型id不能为空", groups = {Create.class, Update.class})
    @Max(value = 3,  groups = {Create.class, Update.class},message = "培训类型id不能超过3")
    private Integer typeId;

    @ApiModelProperty(value = "培训价格", example = "1000", required = true)
    @NotNull(message = "培训价格不能为空", groups = {Create.class, Update.class})
    @Range(min = 0, max = 100000, message = "价格不能超过100000")
    private BigDecimal price;

    //@ApiModelProperty(value = "培训地点不能为空", example = "广东省深圳市南山区XXX001", required = true)
    //@NotBlank(message = "培训地点不能为空", groups = {Create.class, Update.class})
    private String place;

    @ApiModelProperty(value = "培训主图不能为空", example = "http://", required = true)
    @NotBlank(message = "培训主图不能为空", groups = {Create.class, Update.class})
    private String mainImage;

    @ApiModelProperty(value = "机构id", hidden = true)
    private Integer orgId;

    @Override
    public boolean equals(Object train) {
        LicenseTrainingProgramsVO programsVO = (LicenseTrainingProgramsVO) train;
        if (this.gradeId.equals(programsVO.getGradeId()) && this.modelsId.equals(programsVO.getModelsId())
                && this.typeId.equals(programsVO.getTypeId())) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(gradeId, modelsId, typeId);
    }
}
