package com.mmc.csf.user.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/10/7 19:48
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserAccountMessageVo implements Serializable {
    private static final long serialVersionUID = 7067111726018678883L;
    @ApiModelProperty(value = "用户id")
    @NotNull(message = "userId")
    private Integer userAccountId;

    @ApiModelProperty(value = "性别" ,example = "1")
    private Integer sex;
    @ApiModelProperty(value = "年龄" ,example = "1")
    private Integer birthday;

    private Integer pilotId;
    @ApiModelProperty(value = "能力" ,example = "1")
    private List<String> abilityName;
    @ApiModelProperty(value = "工作年限" ,example = "1")
    private Integer yearsOfWorking;

}
