package com.mmc.csf.release.feign;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.feign.hystrix.PmsAppApHystrix;
import com.mmc.csf.release.flyer.dto.AllCategoryDTO;
import com.mmc.csf.release.forum.vo.MallGoodsVO;
import com.mmc.csf.release.industry.IndustryTypeDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/10 20:23
 */
@FeignClient(url = "${iuav.pmsapp.url}", name = "pms-svc", fallback = PmsAppApHystrix.class)
public interface PmsAppApi {
    @RequestMapping(value = "/pms/classify/feignQqueryCategoryInfoByType", method = RequestMethod.GET)
    public List<AllCategoryDTO> feignQqueryCategoryInfoByType(@RequestParam Integer type);

    @RequestMapping(value = "/pms/industry/getIndustryTypeById", method = RequestMethod.GET)
    public IndustryTypeDTO feignQquerygetIndustryTypeById(@RequestParam Integer id);


    //根据商品id 查找商品信息
    @RequestMapping(value = "/pms/mall/goods/mallGoodsDetails", method = RequestMethod.GET)
    public ResultBody<MallGoodsVO> mallGoodsDetails(@RequestParam Integer id);

}
