package com.mmc.csf.release.controller;

import com.mmc.csf.release.service.WxApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Author LW
 * @date 2023/7/12 17:32
 * 概要：
 */
@Api(tags = {"wx-api"})
@RestController
@RequestMapping("/wechat")
public class WxApiController {
    @Resource
    WxApiService wxApiService;

    /**
     * 正确响应微信发送的Token验证,注意 这里是 get请求
     */
    @GetMapping("/checkSignature")
    @ApiOperation(value = "校验签名")
    public String verifyUrl(@RequestParam Map<String, String> params) throws Exception {
        return wxApiService.checkSignature(params);
    }
}
