package com.mmc.csf.release.entity;

import com.mmc.csf.web.dto.DummyFlyerDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Author: geDuo
 * Date: 2022/5/27 17:50
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DummyFlyerDO implements Serializable {
    private Integer id;
    private String flyerName;
    private String phoneNum;
    private Double lon;
    private Double lat;
    private Double distance;

    public DummyFlyerDO(DummyFlyerDTO d) {
        this.flyerName = d.getFlyerName();
        this.phoneNum = d.getPhoneNum();
        this.lon = d.getLon();
        this.lat = d.getLat();
    }

    public DummyFlyerDTO buildDummyFlyerDTO() {
        this.distance = this.distance == null ? 0 : (BigDecimal.valueOf(this.distance).setScale(2, BigDecimal.ROUND_HALF_DOWN)).doubleValue();
        return DummyFlyerDTO.builder().flyerName(this.flyerName).phoneNum(this.phoneNum).lon(this.lon).lat(this.lat).distance(this.distance / 1000).build();
    }
}
