package com.mmc.csf.release.entity.module;

import com.mmc.csf.infomation.dto.BannerInfoDTO;
import com.mmc.csf.infomation.vo.BannerInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/23 14:28
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BannerInfoDO implements Serializable {
    private static final long serialVersionUID = 1041918314535866878L;
    private Integer id;
    /**
     * 模块id
     */
    private Integer moduleId;
    /**
     * 名称
     */
    private String bannerName;
    /**
     * 封面图url
     */
    private String bannerImg;
    /**
     * banner类型（0无，1海报，3 路由  路由（需要授权）等）
     */
    private Integer bannerType;
    /**
     * 页面url
     */
    private String bannerUrl;
    /**
     * 描述信息
     */
    private String detailInfo;
    private Integer sort;

    /**
     * 有效开始时间
     */
    private Date startTime;
    /**
     * 有效结束时间
     */
    private Date endTime;
    /**
     * 0未上架，1上架
     */
    private Integer using;
    /**
     * 0未删 1已删
     */
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public BannerInfoDTO buildBannerInfoDTO(){
        Date now = new Date();
        Integer bannerType = this.bannerType;
        String bannerPoster=null;
        String textContent=null;
        String bannerUrls=null;
        if ("1".equals(bannerType.toString())){
            bannerPoster = this.bannerUrl;
        }else if("11".equals(bannerType.toString())){
            textContent=this.bannerUrl;
        }else if(!"1".equals(bannerType.toString()) && !"11".equals(bannerType.toString())){
            bannerUrls=this.bannerUrl;
        }
        return BannerInfoDTO.builder()
                .id(this.id).moduleId(this.moduleId).bannerName(this.bannerName).bannerImg(this.bannerImg)
                .bannerPoster(bannerPoster).sort(this.sort).using(this.endTime != null ? ( now.before(this.endTime) ? (this.using == 1 ? 1 : 0) : 0 ) : (this.using == 1 ? 1 : 0))
                .deleted(this.deleted).createTime(this.createTime).bannerType(this.bannerType).bannerUrl(bannerUrls).textContent(textContent)
                .detailInfo(this.detailInfo).startTime(this.startTime).endTime(this.endTime).build();
    }

    public BannerInfoDO(BannerInfoVO bannerInfoVO){
        if ("1".equals(bannerInfoVO.getBannerType().toString())){
            this.bannerUrl = bannerInfoVO.getBannerPoster();
        }else if("11".equals(bannerInfoVO.getBannerType().toString())){
            this.bannerUrl = bannerInfoVO.getTextContent();
        }else if(!"1".equals(bannerInfoVO.getBannerType().toString()) && !"11".equals(bannerInfoVO.getBannerType().toString())){
            this.bannerUrl = bannerInfoVO.getBannerUrl();
        }
        this.id = bannerInfoVO.getId();
        this.moduleId = bannerInfoVO.getModuleId();
        this.bannerName = bannerInfoVO.getBannerName();
        this.bannerImg = bannerInfoVO.getBannerImg();
        this.bannerType = bannerInfoVO.getBannerType();
        this.sort = bannerInfoVO.getSort();
        this.using = bannerInfoVO.getUsing();
        this.detailInfo = bannerInfoVO.getDetailInfo();
        this.startTime = bannerInfoVO.getStartTime();
        this.endTime = bannerInfoVO.getEndTime();
    }
}
