package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.infomation.vo.RequirementsTypeVO;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.RequirementsInfoDO;
import com.mmc.csf.release.entity.requirements.RequirementsTypeDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.RequirementsService;
import com.mmc.csf.release.util.RestTemplateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
@Slf4j
@Service
public class RequirementsServiceImpl implements RequirementsService {
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Autowired
    private RestTemplateUtil restTemplateUtil;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.omsapp.url}")
    private String omsApp;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public ResultBody listType(Integer id) {
        List<RequirementsTypeDO> requirementsTypeDOList = requirementsDao.listTypeReq(id);
        List<RequirementsTypeVO> requirementsTypeVOList = requirementsTypeDOList.stream().map(RequirementsTypeDO::buildRequirementsTypeVO).collect(Collectors.toList());
        return ResultBody.success(requirementsTypeVOList);
    }

    @Override
    public ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        //是否完成认证
//        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(requirementsInfoVO.getUserAccountId());
//        if (userAccountSimpleDTO == null || !userAccountSimpleDTO.getCompanyAuthStatus().toString().equals("1")){
//            return ResultBody.error(ResultEnum.COMPANY_NOT_VERIFY_ERROR);
//        }

        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        requirementsDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    HttpHeaders headers = new HttpHeaders();


    @Override
    public ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.getRequirementsInfoById(requirementsInfoId);
        if (!requirementsInfoDO.getUserAccountId().toString().equals(userAccountId.toString())) {
            return ResultBody.error("无权限");
        }
        requirementsDao.solveRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        int count = requirementsDao.countListPublishPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<RequirementsInfoDO> requirementsInfoDOList = requirementsDao.listPublishPage(industryCaseQO);
        List<RequirementsInfoVO> requirementsInfoVOS = requirementsInfoDOList.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        Map<Integer, String> collect = requirementsDao.listType().stream().collect(Collectors.toMap(RequirementsTypeDO::getId, d -> d.getTypeName()));
        for (RequirementsInfoVO requirementsInfoVO : requirementsInfoVOS) {
            requirementsInfoVO.setRequirementTypeName(collect.get(requirementsInfoVO.getRequirementTypeId()));
        }
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, requirementsInfoVOS));
    }

    @Override
    public ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId) {
        requirementsDao.removeRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        Integer publish = requirementsDao.findPublish(requirementsInfoDO);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_MODIFY_REQUIREMENTS_PUBLISHED_BY_OTHERS);
        }
        requirementsDao.updatePublish(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deletePublish(Integer id, Integer userAccountId) {
        Integer publish = requirementsDao.findPublishCount(id, userAccountId);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS);
        }
        requirementsDao.requirementsDao(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody appPublishList() {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.appPublishList();
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());

        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }

        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        requirementsInfoVO.setPublishPhone("");
        return ResultBody.success(requirementsInfoVO);
    }

    public ResultBody releaseOrder(RequirementsInfoVO requirementsInfoVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(requirementsInfoVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(omsApp + "releaseOrder/publish", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    public String randomOrderCode() {
        SimpleDateFormat dmDate = new SimpleDateFormat("yyyyMMddHHmmss");
        String ranData = getRandom(6);
        Date date = new Date();
        String dateRan = dmDate.format(date);
        String xsCode = "R" + dateRan + ranData;
        if (xsCode.length() < 24) {
            xsCode = xsCode + 0;
        }
        return xsCode;
    }

    public String getRandom(int len) {
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; i++) {
            rs.append(r.nextInt(10));
        }
        return rs.toString();
    }


}
