package com.mmc.csf.infomation.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 15:14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class RequirementsInfoVO implements Serializable {
    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "需求发布id", hidden = true)
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "需求类型id", example = "1", required = true)
    @NotNull(message = "需求类型id不能为空", groups = {Insert.class, Update.class})
    private Integer requirementTypeId;

    @ApiModelProperty(value = "任务标题", example = "任务标题001", required = true)
    @NotBlank(message = "任务标题不能为空", groups = {Insert.class, Update.class})
    @Size(max = 15, message = "任务标题限制15个字")
    private String taskTitle;

    @ApiModelProperty(value = "任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskStartTime;

    @ApiModelProperty(value = "任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "任务经度", example = "23.344324", required = true)
    @NotNull(message = "任务经度不能为空", groups = {Insert.class, Update.class})
    private Double longitude;

    @ApiModelProperty(value = "任务纬度", example = "44.344324", required = true)
    @NotNull(message = "任务纬度不能为空", groups = {Insert.class, Update.class})
    private Double latitude;


    @ApiModelProperty(value = "需求描述", example = "描述一下", required = true)
    @NotNull(message = "需求描述不能为空", groups = {Insert.class})
    @Length(max = 300, message = "字符过长")
    private String requireDescription;

    @ApiModelProperty(value = "描述图片", example = "http://,http://", required = false)
    private String requireUrl;


    @ApiModelProperty(value = "发布者姓名", example = "张三")
    // @NotNull(message = "发布者姓名不能为空", groups = {Insert.class})
    private String publishName;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = true)
    @NotNull(message = "发布者电话不能为空", groups = {Insert.class})
    private String publishPhone;


    /**
     * 后台获取token里面的用户id
     */
    @ApiModelProperty(value = "用户id", hidden = true)
    //@NotNull(message = "用户id不能为空", groups = {Insert.class})
    private Integer userAccountId;


    @ApiModelProperty(value = "省份编码", required = false)
    //@NotNull(message = "省份编码不能为空", groups = {Insert.class})
    private Integer provinceCode;
    @ApiModelProperty(value = "市编码", required = false)
    private Integer cityCode;
    @ApiModelProperty(value = "区编码", required = false)
    private Integer districtCode;


    @ApiModelProperty(value = "是否已解决")
    private Boolean solved;


    @ApiModelProperty(value = "类型名称", hidden = true)
    private String requirementTypeName;


    @ApiModelProperty(value = "订单编号")
    private String orderNumber;

    @ApiModelProperty(value = "应支付金额 单位元", example = "1.00")
    private BigDecimal paramMoney;

    @ApiModelProperty(value = "发布者id", example = "1", required = true)
    private Integer publishAccountId;

}
