package com.mmc.csf.release.forum.qo;

import java.io.Serializable;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.Api;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author LW
 *
 * @date 2023/6/19 11:12 概要：
 */
@Data
public class DynamicQO implements Serializable {
  @ApiModelProperty(value = "关键字", required = false, example = "111")
  private String keyword;

  @ApiModelProperty(value = "页码", required = true, example = "1")
  @NotNull(
      message = "页码不能为空",
      groups = {Page.class})
  @Min(value = 1, groups = Page.class)
  private Integer pageNo;

  @ApiModelProperty(value = "每页显示数", required = true, example = "10")
  @NotNull(
      message = "每页显示数不能为空",
      groups = {Page.class})
  @Min(value = 1, groups = Page.class)
  private Integer pageSize;

  @ApiModelProperty(value = "审核状态")
  private Integer status;

  public void buildCurrentPage() {
    this.pageNo = (pageNo - 1) * pageSize;
  }
}
