package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.IndustryCaseVO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.IndustryCaseDao;
import com.mmc.csf.release.entity.information.IndustryCaseDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.IndustryCaseService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/19 13:40
 */
@Service
public class IndustryCaseServiceImpl implements IndustryCaseService {
    @Autowired
    private IndustryCaseDao industryCaseDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    public ResultBody listCasePage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        if (industryCaseQO.getProvinceCode() != null) {
            List<Integer> userIds = userAppApi.feignListUserAccountIds(industryCaseQO.getProvinceCode(), industryCaseQO.getCityCode(), industryCaseQO.getDistrictCode(), request.getHeader(TokenConstant.TOKEN));
            if (CollectionUtils.isEmpty(userIds)) {
                return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), 0));
            }
            industryCaseQO.setUserIds(userIds);
        }
        int count = industryCaseDao.countListCasePage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<IndustryCaseDO> industryCaseDOList = industryCaseDao.listCasePage(industryCaseQO);
        List<IndustryCaseVO> industryCaseVOS = industryCaseDOList.stream().map(IndustryCaseDO::buildIndustryCaseVO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, industryCaseVOS));
    }

    @Override
    public ResultBody details(Integer id) {
        IndustryCaseDO industryCaseDO = industryCaseDao.details(id);
        if (industryCaseDO != null) {
            return ResultBody.success(industryCaseDO.buildIndustryCaseVO());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody addCase(IndustryCaseVO industryCaseVO, LoginSuccessDTO userLoginInfo) {
        IndustryCaseDO industryCaseDO = new IndustryCaseDO(industryCaseVO);
        industryCaseDO.setUserAccountId(userLoginInfo.getUserAccountId());
        industryCaseDao.insertIndustryCase(industryCaseDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateCase(IndustryCaseVO industryCaseVO, LoginSuccessDTO userLoginInfo) {
        IndustryCaseDO industryCaseDO = new IndustryCaseDO(industryCaseVO);
        industryCaseDao.updateCase(industryCaseDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteDetails(Integer id) {
        industryCaseDao.removeDetail(id);
        return ResultBody.success();
    }

}